<?php
/* ==========================================================
  Lists
=========================================================== */
if ( !function_exists('roof_list_function')) {
  function roof_list_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'list_style'  => '',
      'list_items'  => '',
      'class'  => '',
      // Style
      'text_color'  => '',
      'icon_color'  => '',
      'text_size'  => '',
      'icon_size'  => '',
      'title_color'  => '',
      'title_size'  => '',
    ), $atts));

    // Group Field
    $list_items = (array) vc_param_group_parse_atts( $list_items );
    $get_each_list = array();
    foreach ( $list_items as $list_item ) {
      $each_list = $list_item;
      $each_list['list_title'] = isset( $list_item['list_title'] ) ? $list_item['list_title'] : '';
      $each_list['list_text'] = isset( $list_item['list_text'] ) ? $list_item['list_text'] : '';
      $get_each_list[] = $each_list;
    }

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    if ( $text_color || $text_size ) {
      $inline_style .= '.roof-list-'. $e_uniqid .' li, .roof-list-'. $e_uniqid .' li p, .roof-list-'. $e_uniqid .' li a {';
      $inline_style .= ( $text_color ) ? 'color:'. $text_color .';' : '';
      $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $title_size || $title_color ) {
      $inline_style .= '.roof-list-'. $e_uniqid .' h5, .roof-list-'. $e_uniqid .'.roof-list-three li strong, .roof-list-'. $e_uniqid .'.roof-list-two strong {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_core_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_color || $icon_size ) {
      if ($list_style === 'roof-list-one') {
        $inline_style .= '.roof-list-'. $e_uniqid .' li:before{';
        $inline_style .= ( $icon_color ) ? 'background-color:'. $icon_color .';' : '';
        $inline_style .= ( $icon_size ) ? 'width:'. roof_core_check_px($icon_size) .';height:'. roof_core_check_px($icon_size) .';' : '';
      } else {
        $inline_style .= '.roof-list-'. $e_uniqid .' li i {';
        $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
        $inline_style .= ( $icon_size ) ? 'font-size:'. roof_core_check_px($icon_size) .';' : '';
      }
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-list-'. $e_uniqid;

    if ($list_style === 'roof-list-two') {
      $output = '<ul class="roof-list-two '. $class . $styled_class .'">';
    } else {
      $output = '<ul class="square-bullets '. $class . $styled_class .'">';
    }

    // Group Param Output
    if ($list_style === 'roof-list-two') {
      foreach ( $get_each_list as $each_list ) {
        $list_title = $each_list['list_title'] ? '<strong>'. $each_list['list_title'] .' :</strong> ' : '';
        $output .= '<li>';
        $output .= $list_title . $each_list['list_text'] .'</li>';
      }
    } else {
      foreach ( $get_each_list as $each_list ) {
        $output .= '<li>'. $each_list['list_text'] .'</li>';
      }
    }

    $output .= '</ul>';

    return $output;
  }
}
add_shortcode( 'roof_list', 'roof_list_function' );
