<?php
/**
 * List - Shortcode Options
 */
add_action( 'init', 'roof_list_vc_map' );
if ( ! function_exists( 'roof_list_vc_map' ) ) {
  function roof_list_vc_map() {
    vc_map( array(
      "name" => __( "List", 'roof-core'),
      "base" => "roof_list",
      "description" => __( "List Styles", 'roof-core'),
      "icon" => "fa fa-list color-red",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'List Style', 'roof-core' ),
          'value' => array(
            __( 'Style One (Simple Square)', 'roof-core' ) => 'roof-list-one',
            __( 'Style Two (Person Details)', 'roof-core' ) => 'roof-list-two',
          ),
          'admin_label' => true,
          'param_name' => 'list_style',
          'description' => __( 'Select your list style.', 'roof-core' ),
        ),

        // List
        array(
          'type' => 'param_group',
          'value' => '',
          'heading' => __( 'Lists', 'roof-core' ),
          'param_name' => 'list_items',
          // Note params is mapped inside param-group:
          'params' => array(
            array(
              'type' => 'textfield',
              'value' => '',
              'admin_label' => true,
              'heading' => __( 'Title', 'roof-core' ),
              'dependency' => array(
                'element' => 'list_style',
                'value' => 'roof-list-two',
              ),
              'param_name' => 'list_title',
            ),
            array(
              'type' => 'textarea',
              'value' => '',
              'heading' => __( 'Text', 'roof-core' ),
              'param_name' => 'list_text',
            ),

          )
        ),
        RoofLib::vt_class_option(),

        // Style
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Text Color', 'roof-core' ),
          'param_name' => 'text_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Bullet/Icon Color', 'roof-core' ),
          'param_name' => 'icon_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Text Size', 'roof-core' ),
          'param_name' => 'text_size',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Bullet/Icon Size', 'roof-core' ),
          'param_name' => 'icon_size',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Title Color', 'roof-core' ),
          'param_name' => 'title_color',
          'group' => __( 'Style', 'roof-core' ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'description' => __( 'Pick your title color.', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Title Size', 'roof-core' ),
          'param_name' => 'title_size',
          'group' => __( 'Style', 'roof-core' ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'description' => __( 'Enter the px value if you used title area in list style type one.', 'roof-core' ),
        ),

      )
    ) );
  }
}
