<?php
/**
 * Job Details - Shortcode Options
 */
add_action( 'init', 'roof_job_details_vc_map' );
if ( ! function_exists( 'roof_job_details_vc_map' ) ) {
  function roof_job_details_vc_map() {
    vc_map( array(
      "name" => __( "Job Details", 'roof-core'),
      "base" => "roof_job_details",
      "description" => __( "Job Details Styles", 'roof-core'),
      "icon" => "fa fa-info-circle color-pink",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Job Details Column', 'roof-core' ),
          'value' => array(
            __( 'Select Column', 'roof-core' ) => '',
            __( 'Column One', 'roof-core' ) => 'roof-jd-col-1',
            __( 'Column Two', 'roof-core' ) => 'roof-jd-col-2',
            __( 'Column Three', 'roof-core' ) => 'roof-jd-col-3',
            __( 'Column Four', 'roof-core' ) => 'roof-jd-col-4',
            __( 'Column Five', 'roof-core' ) => 'roof-jd-col-5',
          ),
          'admin_label' => true,
          'param_name' => 'job_details_column',
          'description' => __( 'Select your job details column.', 'roof-core' ),
        ),

        // Job Details
        array(
          'type' => 'param_group',
          'value' => '',
          'heading' => __( 'Job Details', 'roof-core' ),
          'param_name' => 'job_details_items',
          // Note params is mapped inside param-group:
          'params' => array(
            array(
              'type' => 'vt_icon',
              'value' => '',
              'heading' => __( 'Select Icon', 'roof-core' ),
              'param_name' => 'select_icon',
            ),
            array(
              'type' => 'textfield',
              'value' => '',
              'heading' => __( 'Category Title', 'roof-core' ),
              'param_name' => 'job_details_title',
              'admin_label' => true,
            ),
            array(
              'type' => 'textarea',
              'value' => '',
              'heading' => __( 'Category Text', 'roof-core' ),
              'param_name' => 'job_details_text',
            ),

          )
        ),
        RoofLib::vt_class_option(),

        // Style
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Icon Color', 'roof-core' ),
          'param_name' => 'icon_color',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Category Title Color', 'roof-core' ),
          'param_name' => 'title_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Category Text Color', 'roof-core' ),
          'param_name' => 'text_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Border Color', 'roof-core' ),
          'param_name' => 'border_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Background Color', 'roof-core' ),
          'param_name' => 'bg_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          "type"        => "notice",
          "heading"     => __( "Text Sizes", 'roof-core' ),
          "param_name"  => 'txt_sizes',
          'class'       => 'cs-warning',
          'value'       => '',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Icon Size', 'roof-core' ),
          'param_name' => 'icon_size',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Category Title Size', 'roof-core' ),
          'param_name' => 'title_size',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Category Text Size', 'roof-core' ),
          'param_name' => 'text_size',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),

      )
    ) );
  }
}
