<?php
/* ==========================================================
  Image Link
=========================================================== */
if ( !function_exists('roof_image_link_function')) {
  function roof_image_link_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'image_link_image'  => '',
      'btn_txt'  => '',
      'select_icon'  => '',
      'btn_link'  => '',
      'open_link'  => '',
      'class'  => '',

      // Style
      'img_over_color' => '',
      'img_over_hover_color'  => '',
      'btn_txt_size'  => '',
      'btn_icon_size' => '',
      'btn_bg_color' => '',
      'btn_bg_hover_color' => '',
      'btn_txt_color' => '',
      'btn_txt_hover_color' => '',
      'btn_icon_color' => '',
      'btn_icon_hover_color' => '',
    ), $atts));

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $img_over_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .link-info {';
      $inline_style .= ( $img_over_color ) ? 'background:'. $img_over_color .';' : '';
      $inline_style .= '}';
    }
    if ( $img_over_hover_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.'.hover .link-info {';
      $inline_style .= ( $img_over_hover_color ) ? 'background:'. $img_over_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_txt_size || $btn_txt_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .link-info .roof-btn {';
      $inline_style .= ( $btn_txt_color ) ? 'color:'. $btn_txt_color .';' : '';
      $inline_style .= ( $btn_txt_size ) ? 'font-size:'. roof_check_px($btn_txt_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_txt_hover_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .link-info .roof-btn:hover {';
      $inline_style .= ( $btn_txt_hover_color ) ? 'color:'. $btn_txt_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_icon_size || $btn_icon_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .link-info .roof-btn .fa {';
      $inline_style .= ( $btn_icon_color ) ? 'color:'. $btn_icon_color .';' : '';
      $inline_style .= ( $btn_icon_size ) ? 'font-size:'. roof_check_px($btn_icon_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_bg_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .roof-btn-gray {';
      $inline_style .= ( $btn_bg_color ) ? 'background-color:'. $btn_bg_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_bg_hover_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .link-info .roof-btn:hover {';
      $inline_style .= ( $btn_bg_hover_color ) ? 'background-color:'. $btn_bg_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_icon_hover_color ) {
      $inline_style .= '.image-link-'.$e_uniqid.' .link-info .roof-btn:hover fa {';
      $inline_style .= ( $btn_icon_hover_color ) ? 'color:'. $btn_icon_hover_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' image-link-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';
    $select_icon = $select_icon ? '<i class="'.$select_icon.'" aria-hidden="true"></i>' : '';
    $btn_link = $btn_link ? '<a href="'.$btn_link.'"'.$open_link.' class="roof-btn roof-btn-gray">'.$btn_txt.''.$select_icon.'</a>' : '<span class="roof-btn roof-btn-gray">'.$btn_txt.''.$select_icon.'</span>';
    $img_btn = $btn_txt ? $btn_link : '';

    // Image
    $image_url = wp_get_attachment_url( $image_link_image );
    $resizer = cs_get_option('disable_resizer');
    if($resizer) {
      $link_img = $image_url;
    } else {
      if(class_exists('Aq_Resize')) {
        $link_img = aq_resize( $image_url, '270', '150', true );
      } else {
        $link_img = $image_url;
      }
    }
    $image_link_image_main = $image_link_image ? '<div class="roof-picture"><img src="'.$link_img.'" alt="'.$btn_txt.'"></div>' : '';

    $output = '';

    $output .= '<div class="link-item '.$styled_class.'">'.$image_link_image_main.'<div class="link-info"><div class="roof-table-container"><div class="roof-align-container">'.$img_btn.'</div></div></div></div>';

    return $output;
  }
}
add_shortcode( 'roof_image_link', 'roof_image_link_function' );
