<?php
/**
 * Image Link - Shortcode Options
 */
add_action( 'init', 'roof_image_link_vc_map' );
if ( ! function_exists( 'roof_image_link_vc_map' ) ) {
  function roof_image_link_vc_map() {
    vc_map( array(
      "name" => __( "Image Link", 'roof-core'),
      "base" => "roof_image_link",
      "description" => __( "Image Link Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        RoofLib::vt_open_link_tab(),
        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Image Link Image', 'roof-core'),
          "param_name" => "image_link_image",
          "value"      => "",
          "description" => __( "Set your link image.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Image Link Button Text', 'roof-core'),
          "param_name" => "btn_txt",
          "value"      => "",
          "description" => __( "Enter your button text.", 'roof-core')
        ),
        array(
          "type" => "vt_icon",
          "heading" => __( "Select Button Icon", 'roof-core' ),
          "param_name" => "select_icon",
          'value' => '',
          "description" => __( "Select icon if you want.", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'href',
          "heading"   => __('Button Link', 'roof-core'),
          "param_name" => "btn_link",
          "value"      => "",
          "description" => __( "Enter your button link.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        RoofLib::vt_class_option(),

        // Style
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Image Overlay Color', 'roof-core'),
          "param_name" => "img_over_color",
          "value"      => "",
          "description" => __( "Pick your image overlay color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Image Overlay Hover Color', 'roof-core'),
          "param_name" => "img_over_hover_color",
          "value"      => "",
          "description" => __( "Pick your image overlay hover color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"         => 'textfield',
          "heading"      => __(' button Text Size', 'roof-core'),
          "param_name"   => "btn_txt_size",
          "value"        => "",
          "group"        => "Style",
          "description"  => __( "Enter the numeric value for button text size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"         => 'textfield',
          "heading"      => __(' button Icon Size', 'roof-core'),
          "param_name"   => "btn_icon_size",
          "value"        => "",
          "group"        => "Style",
          "description"  => __( "Enter the numeric value for button icon size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Button BG Color', 'roof-core'),
          "param_name" => "btn_bg_color",
          "value"      => "",
          "description" => __( "Pick your butotn background color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Button BG Hover Color', 'roof-core'),
          "param_name" => "btn_bg_hover_color",
          "value"      => "",
          "description" => __( "Pick your butotn background hover color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        array(
          "type"         => 'colorpicker',
          "heading"      => __('Button Text Color', 'roof-core'),
          "param_name"   => "btn_txt_color",
          "value"        => "",
          "description"  => __( "Pick your button text color.", 'roof-core'),
          "group"        => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"         => 'colorpicker',
          "heading"      => __('Button Text Hover Color', 'roof-core'),
          "param_name"   => "btn_txt_hover_color",
          "value"        => "",
          "description"  => __( "Pick your button text hover color.", 'roof-core'),
          "group"        => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Button Icon Color', 'roof-core'),
          "param_name" => "btn_icon_color",
          "value"      => "",
          "description" => __( "Pick your butotn icon color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Button Icon Hover Color', 'roof-core'),
          "param_name" => "btn_icon_hover_color",
          "value"      => "",
          "description" => __( "Pick your butotn icon hover color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

      )
    ) );
  }
}
