<?php
/* ==========================================================
  Description Box
=========================================================== */
if ( !function_exists('roof_description_box_function')) {
  function roof_description_box_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'description_details'  => '',
      // Style
      'bg_color' => '',
      'title_color'  => '',
      'title_size'  => '',
      'content_color'  => '',
      'content_hover_color'  => '',
      'content_size'  => '',
      'class'  => '',
    ), $atts));

    // Group Field
    $description_details = (array) vc_param_group_parse_atts( $description_details );

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $title_color || $title_size) {
      $inline_style .= '.description-'.$e_uniqid.' .description-box-element h4 {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $content_color || $content_size) {
      $inline_style .= '.description-'.$e_uniqid.' .description-box-element p {';
      $inline_style .= ( $content_color ) ? 'color:'. $content_color .';' : '';
      $inline_style .= ( $content_size ) ? 'font-size:'. roof_check_px($content_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $content_hover_color) {
      $inline_style .= '.description-'.$e_uniqid.' .description-box-element p a:hover {';
      $inline_style .= ( $content_hover_color ) ? 'color:'. $content_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $bg_color) {
      $inline_style .= '.description-'.$e_uniqid.'.roof-description-box {';
      $inline_style .= ( $bg_color ) ? 'background:'. $bg_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' description-'. $e_uniqid;

    $output = '';
    $output .= '<div class="roof-description-box '.$styled_class.' '. $class .'">';

    foreach ( $description_details as $each_description ) {

      $title = $each_description['description_title'] ? '<h4>'.$each_description['description_title'].'</h4>' : '';
      $content_link = isset($each_description['content_link']) ? '<p><a href="'.$each_description['content_link'].'">'.$each_description['description_content'].'</a></p>' : '<p>'.$each_description['description_content'].'</p>';
      $content = $each_description['description_content'] ? $content_link : '';

      $output .= '<div class="description-box-element">'.$title.''.$content.'</div>';
    }

    $output .= '</div>';

    return $output;
  }
}
add_shortcode( 'roof_description_box', 'roof_description_box_function' );
