<?php
/**
 * Description Box - Shortcode Options
 */
add_action( 'init', 'roof_description_box_vc_map' );
if ( ! function_exists( 'roof_description_box_vc_map' ) ) {
  function roof_description_box_vc_map() {
    vc_map( array(
      "name" => __( "Description Box", 'roof-core'),
      "base" => "roof_description_box",
      "description" => __( "Description Box Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

          RoofLib::vt_class_option(),

          array(
              'type' => 'param_group',
              'value' => '',
              'heading' => __( 'Descriptions', 'roof-core' ),
              'param_name' => 'description_details',
              // Note params is mapped inside param-group:
              'params' => array(

                array(
                  "type"      => 'textfield',
                  "heading"   => __('Title', 'roof-core'),
                  "param_name" => "description_title",
                  "value"      => "",
                  'admin_label' => true,
                  "description" => __( "Enter your Description title.", 'roof-core'),
                ),
                array(
                  "type"      => 'textarea',
                  "heading"   => __('Content', 'roof-core'),
                  "param_name" => "description_content",
                  "value"      => "",
                  "description" => __( "Enter your Description content here.", 'roof-core'),
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Content Link', 'roof-core'),
                  "param_name" => "content_link",
                  "value"      => "",
                  "description" => __( "Enter your Description content link here.", 'roof-core'),
                ),
              ),
          ),

                // Style
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Background Color', 'roof-core'),
                  "param_name" => "bg_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your background color.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Title Color', 'roof-core'),
                  "param_name" => "title_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your heading color.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Title Size', 'roof-core'),
                  "param_name" => "title_size",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Content Color', 'roof-core'),
                  "param_name" => "content_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your content color.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Content Hover Color', 'roof-core'),
                  "param_name" => "content_hover_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your content hover color.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Content Size', 'roof-core'),
                  "param_name" => "content_size",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Enter the numeric value for content size in px.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),

      )
    ) );

  }
}
