<?php
/* ===========================================================
    Button
=========================================================== */
if ( !function_exists('roof_cta_button_function')) {
  function roof_cta_button_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'button_style'  => '',
      'button_text'  => '',
      'button_link'  => '',
      'open_link'  => '',
      'class'  => '',
      // Styling
      'text_color'  => '',
      'text_hover_color'  => '',
      'btn_bg_color'  => '',
      'bg_hover_color'  => '',
      'border_hover_color' => '',
      'text_size'  => '',
      // Icon
      'select_icon'  => '',
      'icon_size'  => '',
      'icon_color'  => '',
      'icon_hover_color'  => '',
      // Design
      'css' => ''
    ), $atts));

    // Design Tab
    $custom_css = ( function_exists( 'vc_shortcode_custom_css_class' ) ) ? vc_shortcode_custom_css_class( $css, ' ' ) : '';

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    // Button Text Color
    if ( $text_color ) {
      $inline_style .= '.roof-btn-'. $e_uniqid .' .roof-btn {';
      $inline_style .= ( $text_color ) ? 'color:'. $text_color .'!important;' : '';
      $inline_style .= '}';
    }
    // Button Text Hover Color
    if ( $text_hover_color ) {
      $inline_style .= '.roof-btn-'. $e_uniqid .':hover .roof-btn, .roof-btn-'. $e_uniqid .':focus .roof-btn, .roof-btn-'. $e_uniqid .':active .roof-btn {';
      $inline_style .= ( $text_hover_color ) ? 'color:'. $text_hover_color .' !important;' : '';
      $inline_style .= '}';
    }
    // Text Size
    if ( $text_size ) {
      $inline_style .= '.roof-btn-'. $e_uniqid .' {';
      $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size) .';' : '';
      $inline_style .= '}';
    }

    if ($button_style === 'cta-btn-two') {
      if ( $btn_bg_color ) {
        $inline_style .= '.roof-btn-'. $e_uniqid .' .roof-btn-black {';
        $inline_style .= ( $btn_bg_color ) ? 'background-color:'. $btn_bg_color .' !important;' : '';
        $inline_style .= '}';
      }
      if ( $bg_hover_color ) {
        $inline_style .= '.consult-style-two.roof-btn-'. $e_uniqid .' .roof-btn-black:hover, .consult-style-two.roof-btn-'. $e_uniqid .' .roof-btn-black:focus, .consult-style-two.roof-btn-'. $e_uniqid .' .roof-btn-black:active {';
        $inline_style .= ( $bg_hover_color ) ? 'background:'. $bg_hover_color .' !important;' : '';
        $inline_style .= '}';
      }
    } else {
    // Button Color
      if ( $btn_bg_color ) {
        $inline_style .= '.roof-btn-'. $e_uniqid .' .roof-btn {';
        $inline_style .= ( $btn_bg_color ) ? 'background:'. $btn_bg_color .' !important;' : '';
        $inline_style .= ( $btn_bg_color ) ? 'border-right-color: '. $btn_bg_color .' !important;' : '';
        $inline_style .= '}';
        $inline_style .= '.roof-btn-'. $e_uniqid .' .roof-btn:before {';
        $inline_style .= ( $btn_bg_color ) ? 'border-right-color: '. $btn_bg_color .' !important;' : '';
        $inline_style .= '}';
      }
      if ( $bg_hover_color ) {
        $inline_style .= '.roof-btn-'. $e_uniqid .' .roof-btn:hover, .roof-btn-'. $e_uniqid .' .roof-btn:focus, .roof-btn-'. $e_uniqid .' .roof-btn:active {';
        $inline_style .= ( $bg_hover_color ) ? 'background:'. $bg_hover_color .' !important;' : '';
        $inline_style .= ( $bg_hover_color ) ? 'border-right-color: '. $bg_hover_color .' !important;' : '';
        $inline_style .= '}';
        $inline_style .= '.roof-btn-'. $e_uniqid .' .roof-btn:hover:before, .roof-btn-'. $e_uniqid .' .roof-btn:focus:before, .roof-btn-'. $e_uniqid .' .roof-btn:active:before {';
        $inline_style .= ( $bg_hover_color ) ? 'border-right-color: '. $bg_hover_color .' !important;' : '';
        $inline_style .= '}';
      }
    }
    // Icon
    if ( $icon_size || $icon_color ) {
      $inline_style .= '.roof-btn-'. $e_uniqid .' i {';
      $inline_style .= ( $icon_size ) ? 'font-size:'. roof_core_check_px($icon_size) .';' : '';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_hover_color ) {
      $inline_style .= '.roof-btn-'. $e_uniqid .':hover i {';
      $inline_style .= ( $icon_hover_color ) ? 'color:'. $icon_hover_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-btn-'. $e_uniqid;

    // Styling
    if ($button_style === 'cta-btn-two') {
      $select_icon = '';
      $btn_class = 'roof-btn-black';
      $consult_class = 'consult-style-two';
    } elseif ($button_style === 'cta-btn-four') {
      $select_icon = '';
      $btn_class = 'roof-btn-big roof-btn-white';
      $consult_class = '';
    } elseif($button_style === 'cta-btn-three') {
      if($select_icon){
        $select_icon = '<i class="'. $select_icon .'"></i>';
      } else {
        $select_icon = '';
      }
      $btn_class = '';
      $consult_class = 'consult-style-three';
    } else {
      if($select_icon){
        $select_icon = '<i class="'. $select_icon .'"></i>';
      } else {
        $select_icon = '';
      }
      $btn_class = '';
      $consult_class = '';
    }

    $open_link = $open_link ? ' target="_blank"' : '';
    $button_link = $button_link ? '<a href="'. $button_link .'" '.$open_link.' class="roof-btn '.$btn_class.'">'. $select_icon . $button_text .'</a>' :'<span class="roof-btn '.$btn_class.'">'. $select_icon . $button_text .'</span>';
    $button_text = $button_text ? $button_link : '';

    $output = '<div class="pull-right '. $consult_class . $custom_css . $styled_class .' '. $class .'">'. $button_text .'</div>';

    return $output;

  }
}
add_shortcode( 'roof_cta_button', 'roof_cta_button_function' );
