<?php
/* ==========================================================
  Partner
=========================================================== */
if ( !function_exists('roof_counter_function')) {
  function roof_counter_function( $atts, $content = NULL, $key = '' ) {

    extract(shortcode_atts(array(
      'counter_style' => '',
      'counter_upload_type' => '',
      'counter_icon_image' => '',
      'counter_image_width' => '',
      'counter_image' => '',
      'counter_title'  => '',
      'counter_value'  => '',
      'counter_value_two' => '',
      'counter_value_in' => '',
      'class'  => '',

      // Style
      'counter_border'     => '',
      'counter_title_color'  => '',
      'counter_value_color'  => '',
      'counter_value_in_color'  => '',
      'counter_title_size'  => '',
      'counter_value_size'  => '',
      'counter_value_in_size'  => '',

      // Progress Bar
      'progress_bar_fill_color' => '',
      'progress_bar_empty_color' => '',
      'progrss_duration' => '',
      'progrss_bar_thickness' => '',
    ), $atts));

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ($counter_style === 'roof-counter-two') {
        if ( $counter_title_color || $counter_title_size) {
          $inline_style .= '.progressbar-item-'.$e_uniqid.' .status-title {';
          $inline_style .= ( $counter_title_color ) ? 'color:'. $counter_title_color .'!important;' : '';
          $inline_style .= ( $counter_title_size ) ? 'font-size:'. roof_check_px($counter_title_size) .';' : '';
          $inline_style .= '}';
        }
        if ( $counter_value_color || $counter_value_size) {
          $inline_style .= '.progressbar-item-'.$e_uniqid.' .status-info h2.counter {';
          $inline_style .= ( $counter_value_color ) ? 'color:'. $counter_value_color .'!important;' : '';
          $inline_style .= ( $counter_value_size ) ? 'font-size:'. roof_check_px($counter_value_size) .';' : '';
          $inline_style .= '}';
        }
        if ( $counter_image_width) {
          $inline_style .= '.progressbar-item-'.$e_uniqid.'.status-list .roof-icon img, .progressbar-item-'.$e_uniqid.'.status-list .roof-icon i {';
          $inline_style .= ( $counter_image_width ) ? 'width:'. roof_check_px($counter_image_width) .';' : '';
          $inline_style .= '}';
        }
    } else {

        if ( $counter_title_color || $counter_title_size) {
          $inline_style .= '.progressbar-item-'.$e_uniqid.' .progressbar-title {';
          $inline_style .= ( $counter_title_color ) ? 'color:'. $counter_title_color .';' : '';
          $inline_style .= ( $counter_title_size ) ? 'font-size:'. roof_check_px($counter_title_size) .';' : '';
          $inline_style .= '}';
        }
        if ( $counter_value_color || $counter_value_size) {
          $inline_style .= '.progressbar-item-'.$e_uniqid.' .progress-counter {';
          $inline_style .= ( $counter_value_color ) ? 'color:'. $counter_value_color .';' : '';
          $inline_style .= ( $counter_value_size ) ? 'font-size:'. roof_check_px($counter_value_size) .';' : '';
          $inline_style .= '}';
        }
        if ( $counter_value_in_color || $counter_value_in_size) {
          $inline_style .= '.progressbar-item-'.$e_uniqid.' .progress-counter:after {';
          $inline_style .= ( $counter_value_in_color ) ? 'color:'. $counter_value_in_color .';' : '';
          $inline_style .= ( $counter_value_in_size ) ? 'font-size:'. roof_check_px($counter_value_in_size) .';' : '';
          $inline_style .= '}';
        }
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' progressbar-item-'. $e_uniqid;

    // Progress Bar Data's
    $all_element_color  = cs_get_customize_option( 'all_element_colors' );
    $fill_color = $progress_bar_fill_color ? 'data-color="'.$progress_bar_fill_color.'"' : 'data-color="'.$all_element_color.'"';
    $empty_color = $progress_bar_empty_color ? 'data-clr="'.$progress_bar_empty_color.'"' : 'data-clr="#f2f2f2"';
    $duration = $progrss_duration ? 'data-duration="'. $progrss_duration .'"' : 'data-duration="1800"';
    $thickness = $progrss_bar_thickness ? 'data-thick="'. $progrss_bar_thickness .'"' : 'data-thick="4"';

    // Icon
    if($counter_icon_image){
      $counter_image_main = '<div class="roof-icon"><i class="roof-counter-icon '.$counter_icon_image.'"></i></div>';
    } elseif($counter_image) {
      $image_url = wp_get_attachment_url( $counter_image );
      $counter_image_main = '<div class="roof-icon"><img src="'.$image_url.'" alt="'. $counter_title .'"></div>';
    } else {
      $counter_image_main = '';
    }

    // Counter Title
    if ($counter_style === 'roof-counter-two') {
      $counter_title = $counter_title ? '<h5 class="status-title" style="'. $counter_title_color . $counter_title_size .'">'. $counter_title .'</h5>' : '';
    } else {
      $counter_title = $counter_title ? '<h4 class="progressbar-title" style="'. $counter_title_color . $counter_title_size .'">'. $counter_title .'</h4>' : '';
    }

    // Value
    if ($counter_style === 'roof-counter-two') {
      $counter_value = $counter_value_two ? '<h2 class="counter">'.$counter_value_two.'</h2>' : '';
    } else {

      if ($counter_value_in === 'counter-percentage') {
        $value_class = '';
      } else {
        $value_class = 'plus';
      }
        $counter_value = $counter_value ? '<div data-value="'.$counter_value.'" class="roof-progressbar '.$value_class.'" '.$fill_color .' '. $empty_color .' '. $duration .' '. $thickness .'><span class="progress-counter"></span></div>' : '';
    }
    // Counters
    if ($counter_style === 'roof-counter-two') {
      $output = '<div class="status-list '.$styled_class.' ' .$class.'">'.$counter_image_main.'<div class="status-info">'.$counter_value . $counter_title .'</div></div>';
    } else {
      if($counter_border){
        $border_class = 'counter-border';
      } else {
        $border_class = '';
      }
    $output = '<div class="roof-performances '.$class.'"><div class="progressbar-item '.$border_class.' '.$styled_class.'">'.$counter_value.' '.$counter_title.'</div></div>';
    }

    // Output
    return $output;

  }
}
add_shortcode( 'roof_counter', 'roof_counter_function' );
