<?php
/**
 * Counter - Shortcode Options
 */
add_action( 'init', 'roof_counter_vc_map' );
if ( ! function_exists( 'roof_counter_vc_map' ) ) {
  function roof_counter_vc_map() {
    vc_map( array(
      "name" => __( "Counter", 'roof-core'),
      "base" => "roof_counter",
      "description" => __( "Counter Styles", 'roof-core'),
      "icon" => "fa fa-sort-numeric-asc color-blue",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Counter Style', 'roof-core' ),
          'value' => array(
            __( 'Style One', 'roof-core' ) => 'roof-counter-one',
            __( 'Style Two', 'roof-core' ) => 'roof-counter-two',
          ),
          'admin_label' => true,
          'param_name' => 'counter_style',
          'description' => __( 'Select your counter style.', 'roof-core' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Upload Icon or Image(select upload type)', 'roof-core' ),
          'value' => array(
            __( '--select--', 'roof-core' ) => '',
            __( 'Icon', 'roof-core' ) => 'roof-icon',
            __( 'Image', 'roof-core' ) => 'roof-image',
          ),
          'param_name' => 'counter_upload_type',
          'description' => __( 'Select your counter style.', 'roof-core' ),
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-two',
          ),
        ),
        array(
          "type"      => 'vt_icon',
          "heading"   => __('Upload Icon', 'roof-core'),
          "param_name" => "counter_icon_image",
          "value"      => "",
          "description" => __( "Set your counter icon image.", 'roof-core'),
          'dependency' => array(
            'element' => 'counter_upload_type',
            'value' => 'roof-icon',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Image', 'roof-core'),
          "param_name" => "counter_image",
          "value"      => "",
          "description" => __( "Set your counter image.", 'roof-core'),
          'dependency' => array(
            'element' => 'counter_upload_type',
            'value' => 'roof-image',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Counter Image Width', 'roof-core'),
          "param_name" => "counter_image_width",
          "value"      => "",
          "description" => __( "Enter the numeric value for icon width in px.", 'roof-core'),
          'dependency' => array(
            'element' => 'counter_upload_type',
            'value' => 'roof-image',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Title', 'roof-core'),
          "param_name"  => "counter_title",
          "value"       => "",
          "description" => __( "Enter your counter title.", 'roof-core')
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Counter Value', 'roof-core'),
          "param_name"  => "counter_value",
          "value"       => "",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "Enter numeric value to count. Ex : 0.2 for 20% ", 'roof-core')
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Counter Value', 'roof-core'),
          "param_name"  => "counter_value_two",
          "value"       => "",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-two',
          ),
          "description" => __( "Enter numeric value to count. Ex : 100 ,500 ,1000 etc., ", 'roof-core')
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Value In', 'roof-core' ),
          'value' => array(
            __( 'Plus', 'roof-core' ) => 'counter-plus',
            __( 'Percentage', 'roof-core' ) => 'counter-percentage',
          ),
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'param_name' => 'counter_value_in',
          'description' => __( 'Select your counter value in.', 'roof-core' ),
        ),
        RoofLib::vt_class_option(),

        // Stylings
        array(
          "type"        =>'switcher',
          "heading"     =>__('Border Right', 'roof-core'),
          "param_name"  => "counter_border",
          "value"       => "",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          "std"         => true,
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Title Color', 'roof-core'),
          "param_name"  => "counter_title_color",
          "value"       => "",
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Counter Value Color', 'roof-core'),
          "param_name"  => "counter_value_color",
          "value"       => "",
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Counter Value In Color', 'roof-core'),
          "param_name"  => "counter_value_in_color",
          "value"       => "",
          "group"       => "Style",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
        ),
        // Size
        array(
          "type"        => 'textfield',
          "heading"     => __('Title Size', 'roof-core'),
          "param_name"  => "counter_title_size",
          "value"       => "",
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "description" => __( "Enter font size in px.", 'roof-core')
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Counter Size', 'roof-core'),
          "param_name"  => "counter_value_size",
          "value"       => "",
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "description" => __( "Enter font size in px.", 'roof-core')
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Counter Value In Size', 'roof-core'),
          "param_name"  => "counter_value_in_size",
          "value"       => "",
          "group"       => "Style",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "description" => __( "Enter font size in px.", 'roof-core')
        ),

        // Progress Bar
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Progress Bar Fill Color', 'roof-core'),
          "param_name"  => "progress_bar_fill_color",
          "value"       => "",
          "group"       => "Progress Bar",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Progress Bar Empty Color', 'roof-core'),
          "param_name"  => "progress_bar_empty_color",
          "value"       => "",
          "group"       => "Progress Bar",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Progress Duration', 'roof-core'),
          "param_name"  => "progrss_duration",
          "value"       => "",
          "group"       => "Progress Bar",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          "description" => __( "Enter numeric value for duration. Ex : 1500 ,2000 ,2500 etc., ", 'roof-core')
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Progress Bar Thickness', 'roof-core'),
          "param_name"  => "progrss_bar_thickness",
          "value"       => "",
          "group"       => "Progress Bar",
          'dependency' => array(
            'element' => 'counter_style',
            'value' => 'roof-counter-one',
          ),
          "description" => __( "Enter numeric value for thickness. Ex : 1 ,2 ,4 ,5 etc., ", 'roof-core')
        ),

      )
    ) );
  }
}
