<?php
/* ==========================================================
    Contact
=========================================================== */
if ( !function_exists('roof_contact_function')) {
  function roof_contact_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'id'  => '',
      'box_style'  => '',
      'form_title'  => '',
      'form_description' => '',
      'class'  => '',
      // Style
      'submit_size'  => '',
      'submit_color'  => '',
      'submit_bg_color'  => '',
    ), $atts));

    $content = wpb_js_remove_wpautop($content, true);

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    // Own Styles
    if ( $submit_size || $submit_color || $submit_bg_color ) {
      $inline_style .= '.roof-contact-'. $e_uniqid .' .wpcf7 input[type="submit"] {';
      $inline_style .= ( $submit_size ) ? 'font-size:'. roof_core_check_px($submit_size) .';' : '';
      $inline_style .= ( $submit_color ) ? 'color:'. $submit_color .';' : '';
      $inline_style .= ( $submit_bg_color ) ? 'background-color:'. $submit_bg_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-contact-'. $e_uniqid;

    // Atts If
    $id = ( $id ) ? $id : '';
    $form_title = ( $form_title ) ? '<h2 class="section-title">'. $form_title .'</h2>' : '';
    $form_description = ( $form_description ) ? '<p>'. $form_description .'</p>' : '';
    $class = ( $class ) ? ' '. $class : '';

    // Starts
    if($box_style === 'contact-box-two'){
      $output  = '<div class="request-quote'. $styled_class . $class .'"><div class="section-title-wrap">';
      $output .= $form_title;
      $output .= $form_description;
      $output .= '</div>';
      $output .= do_shortcode( '[contact-form-7 id="'. $id .'"]' );
      $output .= '</div>';
    } else {
      $output  = '<div class="roof-contact-form'. $styled_class . $box_style . $class .'">';
      $output .= $form_title;
      $output .= do_shortcode( '[contact-form-7 id="'. $id .'"]' );
      $output .= '</div>';
    }

    return $output;

  }
}
add_shortcode( 'roof_contact', 'roof_contact_function' );
