<?php
/**
 * Client Carousel - Shortcode Options
 */
add_action( 'init', 'client_carousel_vc_map' );
if ( ! function_exists( 'client_carousel_vc_map' ) ) {
  function client_carousel_vc_map() {
    vc_map( array(
      "name" => __( "Client", 'roof-core'),
      "base" => "roof_client_carousel",
      "description" => __( "Client Carousel", 'roof-core'),
      "icon" => "fa fa-shield color-green",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        RoofLib::vt_open_link_tab(),

        // Client Logos
        array(
          'type' => 'param_group',
          'value' => '',
          'heading' => __( 'Client Logos', 'roof-core' ),
          'param_name' => 'client_logos',
          // Note params is mapped inside param-group:
          'params' => array(
            array(
              'type' => 'attach_image',
              'value' => '',
              "admin_label"=> true,
              'heading' => __( 'Upload Image', 'roof-core' ),
              'param_name' => 'client_logo',
            ),
            array(
              'type' => 'textfield',
              'value' => '',
              'heading' => __( 'Client Link', 'roof-core' ),
              'param_name' => 'client_link',
            )
          )
        ),
        RoofLib::vt_class_option(),

        // Carousel
        RoofLib::vt_notice_field(__( "Basic Options", 'roof-core' ),'bsic_opt','cs-warning', 'Carousel'), // Notice
        RoofLib::vt_carousel_loop(), // Loop
        RoofLib::vt_carousel_items(), // Items
        array(
          "type" => "switcher",
          "heading" => __( "Dots", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "carousel_dots",
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          "value" => '',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "If you want Carousel Dots, enable it.", 'roof-core')
        ),
        array(
          "type" => "switcher",
          "heading" => __( "Navigation", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "carousel_nav",
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          "value" => '',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "If you want Carousel Navigation, enable it.", 'roof-core')
        ),
        RoofLib::vt_carousel_margin(), // Margin
        RoofLib::vt_notice_field(__( "Auto Play & Interaction", 'roof-core' ),'apyi_opt','cs-warning', 'Carousel'), // Notice
        RoofLib::vt_carousel_autoplay_timeout(), // Autoplay Timeout
        RoofLib::vt_carousel_autoplay(), // Autoplay
        RoofLib::vt_carousel_animateout(), // Animate Out
        RoofLib::vt_notice_field(__( "Width & Height", 'roof-core' ),'wah_opt','cs-warning', 'Carousel'), // Notice
        RoofLib::vt_carousel_autowidth(), // Auto Width
        RoofLib::vt_carousel_autoheight(), // Auto Height
        RoofLib::vt_notice_field('Responsive Options','res_opt','cs-warning', 'Carousel'), // Notice
        RoofLib::vt_carousel_tablet(), // Tablet
        RoofLib::vt_carousel_mobile(), // Mobile
        RoofLib::vt_carousel_small_mobile(), // Small Mobile

      )
    ) );
  }
}
