<?php
/* ==========================================================
  Certifications
=========================================================== */
if ( !function_exists('roof_certifications_function')) {
  function roof_certifications_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'certifications_style'  => '',
      'certifications_alignment'  => '',
      'certifications_icon_image'  => '',
      'certifications_icon_width' => '',
      'certifications_title'  => '',
      'certifications_title_color'  => '',
      'certifications_title_hover_color'  => '',
      'certifications_title_size'  => '',
      'open_link'  => '',
      'class'  => '',

    ), $atts));

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // fix unclosed/unwanted paragraph tags in $content
    $content = wpb_js_remove_wpautop($content, true);

    // Colors & Size
    if ( $certifications_title_color || $certifications_title_size) {
      $inline_style .= '.certification-'.$e_uniqid.' .certification-title a {';
      $inline_style .= ( $certifications_title_color ) ? 'color:'. $certifications_title_color .';' : '';
      $inline_style .= ( $certifications_title_size ) ? 'font-size:'. roof_check_px($certifications_title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $certifications_title_hover_color) {
      $inline_style .= '.certification-'.$e_uniqid.' .certification-title a:hover {';
      $inline_style .= ( $certifications_title_hover_color ) ? 'color:'. $certifications_title_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $certifications_icon_width) {
      $inline_style .= '.certification-'.$e_uniqid.' .roof-icon img {';
      $inline_style .= ( $certifications_icon_width ) ? 'width:'. roof_check_px($certifications_icon_width) .';' : '';
      $inline_style .= '}';
    }

    if ($certifications_alignment === 'center') {
      $align_style = 'text-center';
    } elseif ($certifications_alignment === 'right') {
      $align_style = 'text-right';
    } else {
      $align_style = 'text-left';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' certification-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';

    // Certifications Title
    if ( function_exists( 'vc_parse_multi_attribute' ) ) {
      $parse_args = vc_parse_multi_attribute( $certifications_title );
      $url        = ( isset( $parse_args['url'] ) ) ? $parse_args['url'] : '';
      $title      = ( isset( $parse_args['title'] ) ) ? $parse_args['title'] : '';
      $target     = ( isset( $parse_args['target'] ) ) ? trim( $parse_args['target'] ) : '_self';
    }
    if ($url) {
      $certifications_title = '<h5 class="certification-title"><a href="'. $url .'" target="'. $target .'">'. $title .'</a></h5>';
    } elseif ($title) {
      $certifications_title = '<h5 class="certification-title">'. $title .'</h5>';

    } else {
      $certifications_title = '';
    }

    // Certifications Icon
    $image_url = wp_get_attachment_url( $certifications_icon_image );
    $certifications_icon_image_main = $certifications_icon_image ? '<img src="'.$image_url.'" alt="'. $title .'">' : '';

    $output = '';
    if ($certifications_style === 'roof-certifications-two') {
      $output .= '<div class="roof-certifications '. $styled_class .' certifications-style-two '.$class.'"><div class="certification-item '.$align_style.'"><div class="roof-icon">'.$certifications_icon_image_main.'</div>'.$certifications_title.'<div class="certification-info">'.$content.'</div></div></div>';

    } elseif ($certifications_style === 'roof-certifications-three') {
      $output .= '<div class="roof-certifications '. $styled_class .' certifications-style-three '.$class.'"><div class="certification-item '.$align_style.'"><div class="roof-icon">'.$certifications_icon_image_main.'</div>'.$certifications_title.'<div class="certification-info">'.$content.'</div></div></div>';

    } else {
      $output .= '<div class="roof-certifications certifications-style-one '. $styled_class .' '. $class .'"><div class="certification-item">'.$certifications_title.'<div class="roof-icon">'.$certifications_icon_image_main.'</div><div class="certification-info">'.$content.'</div></div></div>';
    }

    return $output;
  }
}
add_shortcode( 'roof_certifications', 'roof_certifications_function' );
