<?php
/**
 * Certifications - Shortcode Options
 */
add_action( 'init', 'roof_certifications_vc_map' );
if ( ! function_exists( 'roof_certifications_vc_map' ) ) {
  function roof_certifications_vc_map() {
    vc_map( array(
      "name" => __( "Certifications", 'roof-core'),
      "base" => "roof_certifications",
      "description" => __( "Certifications Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Certifications Style', 'roof-core' ),
          'value' => array(
            __( 'Style One', 'roof-core' ) => 'roof-certifications-one',
            __( 'Style Two', 'roof-core' ) => 'roof-certifications-two',
            __( 'Style Three', 'roof-core' ) => 'roof-certifications-three',
          ),
          'admin_label' => true,
          'param_name' => 'certifications_style',
          'description' => __( 'Select your Certifications style.', 'roof-core' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Certifications Alignment', 'roof-core' ),
          'value' => array(
            __( 'Left', 'roof-core' ) => 'left',
            __( 'Right', 'roof-core' ) => 'right',
            __( 'Center', 'roof-core' ) => 'center',
          ),
          'dependency' => array(
            'element' => 'certifications_style',
            'value' => array('roof-certifications-two','roof-certifications-three'),
          ),
          'param_name' => 'certifications_alignment',
          'description' => __( 'Select your Certifications Section Alignment.', 'roof-core' ),
        ),
        RoofLib::vt_open_link_tab(),
        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Icon', 'roof-core'),
          "param_name" => "certifications_icon_image",
          "value"      => "",
          "description" => __( "Set your certifications icon image.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        RoofLib::vt_notice_field(__( "Content Area", 'roof-core' ),'cntara_opt','cs-warning', ''), // Notice
        array(
          "type"      => 'vc_link',
          "heading"   => __('Certifications Title', 'roof-core'),
          "param_name" => "certifications_title",
          "value"      => "",
          "description" => __( "Enter your certifications title and link.", 'roof-core')
        ),
        array(
          "type"      => 'textarea_html',
          "heading"   => __('Content', 'roof-core'),
          "param_name" => "content",
          "value"      => "",
          "description" => __( "Enter your certifications content here.", 'roof-core'),
        ),

        RoofLib::vt_class_option(),
        // Style
        RoofLib::vt_notice_field(__( "Title Options", 'roof-core' ),'title_opt','cs-warning', ''), // Notice
        array(
          "type"      => 'textfield',
          "heading"   => __('Certifications Icon Width', 'roof-core'),
          "param_name" => "certifications_icon_width",
          "value"      => "",
          "description" => __( "Enter the numeric value for icon width in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Color', 'roof-core'),
          "param_name" => "certifications_title_color",
          "value"      => "",
          "description" => __( "Pick your heading color.", 'roof-core'),

          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Hover Color', 'roof-core'),
          "param_name" => "certifications_title_hover_color",
          "value"      => "",
          "description" => __( "Pick your heading hover color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title Size', 'roof-core'),
          "param_name" => "certifications_title_size",
          "value"      => "",
          "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

      )
    ) );
  }
}
