<?php
/**
 * Call to Action2 - Shortcode Options
 */
add_action( 'init', 'ctac_vc_map' );
if ( ! function_exists( 'ctac_vc_map' ) ) {
  function ctac_vc_map() {
    vc_map( array(
      "name" => __( "Call to Action - Content 2", 'roof-core'),
      "base" => "roof_ctac",
      "description" => __( "Call to Action Content-2", 'roof-core'),
      "icon" => "fa fa-font color-slate-blue",
      "as_child" => array('only' => 'roof_ctas'),
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Left Side Image', 'roof-core'),
          "param_name" => "cta_image",
          "value"      => "",
          "description" => __( "Set your left side image.", 'roof-core'),
        ),

        array(
          "type"        => 'textfield',
          "heading"     => __('Title', 'roof-core'),
          "param_name"  => "title_one",
          "value"       => "",
          "description" => __( "Enter your first title.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Sub-Title', 'roof-core'),
          "param_name"  => "sub_title_one",
          "value"       => "",
          "description" => __( "Enter your sub-title.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Cal Us Text', 'roof-core'),
          "param_name"  => "call_us_text",
          "value"       => "",
          "description" => __( "Enter your call us text.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Phone Number', 'roof-core'),
          "param_name"  => "phone_no",
          "value"       => "",
          "description" => __( "Enter your phone number.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        RoofLib::vt_class_option(),

      )
    ) );
  }
}
