<?php
/* Call to Action */
if ( !function_exists('roof_ctas_function')) {
  function roof_ctas_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'cta_style'  => '',
      'cta_alignment'  => '',
      'class'  => '',
    ), $atts));

    // Style
    // $cta_style = ($cta_style === 'style-two') ? 'roof-cta-two ' : 'roof-cta-one ';
    $cta_alignment = ($cta_alignment === 'cta-cnt-right') ? 'cta-cnt-right ' : 'cta-cnt-left ';

    $output = '';
    // Output
    if($cta_style === 'style-two'){
      $output  .= '<div class="roof-emergency roof-parallax"><div class="container"><div class="row">';
      $output  .= do_shortcode($content);
      $output  .= '</div></div></div>';
    } else {
      $output  .= '<div class="roof-consult '. $class .'"><div class="container">';
      $output  .= do_shortcode($content);
      $output  .= '</div></div>';
    }
    return $output;

  }
}
add_shortcode( 'roof_ctas', 'roof_ctas_function' );

/* Call to Action */
if ( !function_exists('roof_cta_function')) {
  function roof_cta_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'content_width'  => '',
      'class'  => '',
    ), $atts));

    // fix unclosed/unwanted paragraph tags in $content
    $content = wpb_js_remove_wpautop($content, true);
    $content = $content ? do_shortcode($content) : '';
    $content_width = $content_width ? 'style="width:'. $content_width .';"' : '';

    // Output
    return '<div class="pull-left '. $class .'" '. $content_width .'>'. $content .'</div>';

  }
}
add_shortcode( 'roof_cta', 'roof_cta_function' );
