<?php
/**
 * Call to Action - Shortcode Options
 */
add_action( 'init', 'ctas_vc_map' );
if ( ! function_exists( 'ctas_vc_map' ) ) {
 function ctas_vc_map() {
   vc_map( array(
     "name" => __( "Call to Action", 'roof-core'),
     "base" => "roof_ctas",
     "description" => __( "Call to Action Group", 'roof-core'),
     "as_parent" => array('only' => 'roof_cta,roof_cta_button,roof_ctac'),
     "content_element" => true,
     "show_settings_on_create" => false,
     "is_container" => true,
     "icon" => "fa fa-bullhorn color-grey",
     "category" => RoofLib::roof_cat_name(),
     "params" => array(

        array(
          "type" => "dropdown",
          "heading" => __( "Call to Action Style", 'roof-core' ),
          "param_name" => "cta_style",
          "value" => array(
            __('Select Call to Action Style', 'roof-core') => '',
            __('Style One', 'roof-core') => 'style-one',
            __('Style Two', 'roof-core') => 'style-two',
          ),
          "admin_label" => true,
          "description" => __( "Select Call to Action style.", 'roof-core')
        ),
        array(
          "type" => "dropdown",
          "heading" => __( "Content Alignment", 'roof-core' ),
          "param_name" => "cta_alignment",
          "value" => array(
            __('Select Content Alignment', 'roof-core') => '',
            __('Content Left & Button Right', 'roof-core') => 'cta-cnt-left',
            __('Content Right & Button Left', 'roof-core') => 'cta-cnt-right',
          ),
          "admin_label" => true,
          "description" => __( "Select Call to Action style.", 'roof-core')
        ),
        RoofLib::vt_class_option(),

     ),
     "js_view" => 'VcColumnView'
   ) );
 }
}

// Call to Action List
add_action( 'init', 'cta_vc_map' );
if ( ! function_exists( 'cta_vc_map' ) ) {
  function cta_vc_map() {
    vc_map( array(
      "name" => __( "Call to Action - Content", 'roof-core'),
      "base" => "roof_cta",
      "description" => __( "Call to Action Content", 'roof-core'),
      "icon" => "fa fa-font color-slate-blue",
      "as_child" => array('only' => 'roof_ctas'),
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          "type"        => 'textfield',
          "heading"     => __('Content Width', 'roof-core'),
          "param_name"  => "content_width",
          "value"       => "",
          "admin_label" => true,
          "description" => __( "Enter your width in %. [Eg: 70%]. Rest of width will go for button.", 'roof-core')
        ),
        array(
          "type"        => 'textarea_html',
          "heading"     => __('Content', 'roof-core'),
          "param_name"  => "content",
          "value"       => "",
          "description" => __( "Explain about your company achievement. Less than two paragraph is recommended.", 'roof-core')
        ),
        RoofLib::vt_class_option(),

      )
    ) );
  }
}
