<?php
/**
 * Button - Shortcode Options
 */
add_action( 'init', 'roof_button_vc_map' );
if ( ! function_exists( 'roof_button_vc_map' ) ) {
  function roof_button_vc_map() {
    vc_map( array(
      "name" => __( "Button", 'roof-core'),
      "base" => "roof_button",
      "description" => __( "Button Styles", 'roof-core'),
      "icon" => "fa fa-mouse-pointer color-orange",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Button Size', 'roof-core' ),
          'value' => array(
            __( 'Select Button Size', 'roof-core' ) => '',
            __( 'Small', 'roof-core' ) => 'roof-btn-small',
            __( 'Medium', 'roof-core' ) => 'roof-btn-medium',
            __( 'Large', 'roof-core' ) => 'roof-btn-large',
          ),
          'admin_label' => true,
          'param_name' => 'button_size',
          'description' => __( 'Select button size', 'roof-core' ),
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Button Text", 'roof-core' ),
          "param_name" => "button_text",
          'value' => '',
          'admin_label' => true,
          "description" => __( "Enter your button text.", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "href",
          "heading" => __( "Button Link", 'roof-core' ),
          "param_name" => "button_link",
          'value' => '',
          "description" => __( "Enter your button link.", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "switcher",
          "heading" => __( "Open New Tab?", 'roof-core' ),
          "param_name" => "open_link",
          "std" => false,
          'value' => '',
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        RoofLib::vt_class_option(),

        // Styling
        array(
          "type" => "colorpicker",
          "heading" => __( "Text Color", 'roof-core' ),
          "param_name" => "text_color",
          'value' => '',
          "group" => __( "Styling", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Text Hover Color", 'roof-core' ),
          "param_name" => "text_hover_color",
          'value' => '',
          "group" => __( "Styling", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Background Color", 'roof-core' ),
          "param_name" => "background_color",
          'value' => '',
          "group" => __( "Styling", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Background Hover Color", 'roof-core' ),
          "param_name" => "bg_hover_color",
          'value' => '',
          "group" => __( "Styling", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Border Color", 'roof-core' ),
          "param_name" => "border_color",
          'value' => '',
          "group" => __( "Styling", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Border Hover Color", 'roof-core' ),
          "param_name" => "border_hover_color",
          'value' => '',
          "group" => __( "Styling", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Text Size", 'roof-core' ),
          "param_name" => "text_size",
          'value' => '',
          "description" => __( "Enter button text font size. [Eg: 14px]", 'roof-core'),
          "group" => __( "Styling", 'roof-core'),
        ),

        // Icon
        array(
          'type' => 'dropdown',
          'heading' => __( 'Icon Alignment', 'roof-core' ),
          'value' => array(
            __( 'Select Icon Alignment', 'roof-core' ) => '',
            __( 'Left', 'roof-core' ) => 'btn-icon-left',
            __( 'Right', 'roof-core' ) => 'btn-icon-right',
          ),
          'param_name' => 'icon_alignment',
          'description' => __( 'Select icon alignment in this button.', 'roof-core' ),
          "group" => __( "Icon", 'roof-core'),
        ),
        array(
          "type" => "vt_icon",
          "heading" => __( "Select Icon", 'roof-core' ),
          "param_name" => "select_icon",
          'value' => '',
          "description" => __( "Select icon if you want.", 'roof-core'),
          "group" => __( "Icon", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Icon Size", 'roof-core' ),
          "param_name" => "icon_size",
          'value' => '',
          "description" => __( "Enter icon size in px.", 'roof-core'),
          "group" => __( "Icon", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Icon Color", 'roof-core' ),
          "param_name" => "icon_color",
          'value' => '',
          "description" => __( "Pick your icon color.", 'roof-core'),
          "group" => __( "Icon", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "colorpicker",
          "heading" => __( "Icon Hover Color", 'roof-core' ),
          "param_name" => "icon_hover_color",
          'value' => '',
          "description" => __( "Pick your icon hover color.", 'roof-core'),
          "group" => __( "Icon", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),

        // Design Tab
        array(
          "type" => "css_editor",
          "heading" => __( "Text Size", 'roof-core' ),
          "param_name" => "css",
          "group" => __( "Design", 'roof-core'),
        ),

      )
    ) );
  }
}
