<?php
/* ==========================================================
  Blog
=========================================================== */
if ( !function_exists('roof_blog_function')) {
  function roof_blog_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'blog_limit'  => '',
      // Enable & Disable
      'blog_hide_content' => '',
      'blog_pagination'  => '',
      // Listing
      'blog_order'  => '',
      'blog_orderby'  => '',
      'blog_show_category'  => '',
      'short_content'  => '',
      'class'  => '',
      // Read More Text
      'read_more_txt'  => '',
      // Miss Align
      'miss_align_height'  => '',
    ), $atts));

    // Excerpt
    if (roof_framework_active()) {
      $excerpt_length = cs_get_option('theme_blog_excerpt');
      $excerpt_length = $excerpt_length ? $excerpt_length : '55';
      if ($short_content) {
        $short_content = $short_content;
      } else {
        $short_content = $excerpt_length;
      }
    } else {
      $short_content = '55';
    }

    // Read More Text
    if (roof_framework_active()) {
      $read_more_to = cs_get_option('read_more_text');
      if ($read_more_txt) {
        $read_more_txt = $read_more_txt;
      } elseif($read_more_to) {
        $read_more_txt = $read_more_to;
      } else {
        $read_more_txt = esc_html__( 'Read More', 'roof-core' );
      }
    } else {
      $read_more_txt = $read_more_txt ? $read_more_txt : esc_html__( 'Read More', 'roof-core' );
    }

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    // Miss-Aligned
    if ( $miss_align_height ) {
      $inline_style .= '.roof-news-'. $e_uniqid .' .news-item {';
      $inline_style .= ( $miss_align_height ) ? 'min-height:'. roof_core_check_px($miss_align_height) .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-news-'. $e_uniqid;

    // Turn output buffer on
    ob_start();

    // Pagination
    global $paged;
    if( get_query_var( 'paged' ) )
      $my_page = get_query_var( 'paged' );
    else {
      if( get_query_var( 'page' ) )
        $my_page = get_query_var( 'page' );
      else
        $my_page = 1;
      set_query_var( 'paged', $my_page );
      $paged = $my_page;
    }

    $args = array(
      // other query params here,
      'paged' => $my_page,
      'post_type' => 'post',
      'posts_per_page' => (int)$blog_limit,
      'category_name' => esc_attr($blog_show_category),
      'orderby' => $blog_orderby,
      'order' => $blog_order
    );

    $roof_post = new WP_Query( $args ); ?>

    <!-- Blog Start -->
    <div class="roof-news row <?php echo esc_attr($styled_class .' '. $class); ?>">

      <?php
      if ($roof_post->have_posts()) : while ($roof_post->have_posts()) : $roof_post->the_post();

        $large_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fullsize', false, '' );
        $large_image = isset($large_image[0]) ? $large_image[0] : '';
        $resizer = cs_get_option('disable_resizer');

        if($resizer) {
          $post_img = $large_image;
        } else {
          if(class_exists('Aq_Resize')) {
              $post_img = aq_resize( $large_image, '370', '230', true );
          } else {$post_img = $large_image;}
        }

        $post_type = get_post_meta( get_the_ID(), 'post_type_metabox', true );
      ?>
      <div class="col-md-4 col-sm-6">
        <div class="news-item">
        <?php if(has_post_thumbnail()) { ?>
          <div class="roof-picture">
            <?php echo '<a href="'.esc_url( get_permalink() ).'"><img src="'. $post_img .'" alt="'. esc_attr(get_the_title()) .'" /></a>'; ?>
          </div>
          <?php } ?>
          <div class="news-info">
            <h6 class="news-meta"><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo get_the_date(); ?></h6>
            <h5 class="news-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h5>
            <?php if (! $blog_hide_content) { ?>
            <p> <?php
                if (roof_framework_active()) {
                  roof_excerpt($short_content);
                } else {
                  the_excerpt();
                } ?>
            </p>
            <?php  } ?>
            <div class="read-more"><a href="<?php echo esc_url( get_permalink() ); ?>" class="roof-btn roof-btn-small roof-btn-gray"><?php echo $read_more_txt; ?></a></div>
          </div>
        </div>
      </div>

      <?php
      endwhile;
      endif;
      wp_reset_postdata(); ?>

    </div>
    <!-- Blog End -->

    <?php
    if ($blog_pagination) {
      if ( function_exists('wp_pagenavi')) {
        wp_pagenavi(array( 'query' => $roof_post ) );
        wp_reset_postdata();  // avoid errors further down the page
      }
    }

    // Return outbut buffer
    return ob_get_clean();

  }
}
add_shortcode( 'roof_blog', 'roof_blog_function' );
