<?php
/**
 * Blog - Shortcode Options
 */
add_action( 'init', 'roof_blog_vc_map' );
if ( ! function_exists( 'roof_blog_vc_map' ) ) {
  function roof_blog_vc_map() {
    vc_map( array(
      "name" => __( "Blog", 'roof-core'),
      "base" => "roof_blog",
      "description" => __( "Blog Styles", 'roof-core'),
      "icon" => "fa fa-newspaper-o color-red",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          "type"        =>'textfield',
          "heading"     =>__('Limit', 'roof-core'),
          "param_name"  => "blog_limit",
          "value"       => "",
          'admin_label' => true,
          "description" => __( "Enter the number of items to show.", 'roof-core'),
        ),

        array(
    			"type"        => "notice",
    			"heading"     => __( "Listing", 'roof-core' ),
    			"param_name"  => 'lsng_opt',
    			'class'       => 'cs-warning',
    			'value'       => '',
    		),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order', 'roof-core' ),
          'value' => array(
            __( 'Select Blog Order', 'roof-core' ) => '',
            __('Asending', 'roof-core') => 'ASC',
            __('Desending', 'roof-core') => 'DESC',
          ),
          'param_name' => 'blog_order',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order By', 'roof-core' ),
          'value' => array(
            __('None', 'roof-core') => 'none',
            __('ID', 'roof-core') => 'ID',
            __('Author', 'roof-core') => 'author',
            __('Title', 'roof-core') => 'title',
            __('Date', 'roof-core') => 'date',
          ),
          'param_name' => 'blog_orderby',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Show only certain categories?', 'roof-core'),
          "param_name"  => "blog_show_category",
          "value"       => "",
          "description" => __( "Enter category SLUGS (comma separated) you want to display.", 'roof-core')
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Short Content (Excerpt Length)', 'roof-core'),
          "param_name"  => "short_content",
          "value"       => "",
          "description" => __( "Enter the numeric value of, how many words you want in short content paragraph.", 'roof-core')
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Hide Content', 'roof-core'),
          "param_name"  => "blog_hide_content",
          "value"       => "",
          "std"         => true,
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Pagination', 'roof-core'),
          "param_name"  => "blog_pagination",
          "value"       => "",
          "std"         => true,
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Read More Button Text', 'roof-core'),
          "param_name"  => "read_more_txt",
          "value"       => "",
          "description" => __( "Enter read more button text.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Miss-Aligned? Mention Minimum Height :', 'roof-core'),
          "param_name"  => "miss_align_height",
          "value"       => "",
          "description" => __( "Enter the px value for minimum height. This will fix miss-aligned issue with your listing items.", 'roof-core')
        ),
        RoofLib::vt_class_option(),

      )
    ) );
  }
}
