<?php
/* ==========================================================
  Services
=========================================================== */
if ( !function_exists('roof_blog_content_function')) {
  function roof_blog_content_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'blog_content_title'  => '',
      'blog_content_read_more_txt'  => '',
      'read_more_link'  => '',
      'open_link' => '',
      'class'  => '',

      // Style
      'title_color' => '',
      'title_size'  => '',
      'read_more_color' => '',
      'read_more_hover_color' => '',
    ), $atts));

    // fix unclosed/unwanted paragraph tags in $content
    $content = wpb_js_remove_wpautop($content, true);

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $title_color || $title_size) {
      $inline_style .= '.expert-item-'.$e_uniqid.' .expert-title {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $read_more_color ) {
      $inline_style .= '.expert-item-'.$e_uniqid.' .view-more a {';
      $inline_style .= ( $read_more_color ) ? 'color:'. $read_more_color .';' : '';
      $inline_style .= '}';
    }
    if ( $read_more_hover_color ) {
      $inline_style .= '.expert-item-'.$e_uniqid.' .view-more a:hover {';
      $inline_style .= ( $read_more_hover_color ) ? 'color:'. $read_more_hover_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' expert-item-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';
    $read_more_link = $read_more_link ? '<div class="view-more"><a href="'.$read_more_link.'" '.$open_link.'>'.$blog_content_read_more_txt.'</a></div>' : '<div class="read-more">'.$blog_content_read_more_txt.'</div>';
    $read_more_txt = $blog_content_read_more_txt ? $read_more_link : '';

    // Title
    $blog_content_title = $blog_content_title ? ' <h5 class="expert-title">'.$blog_content_title.'</h5>' : '';

    $output = '';
    $output .= '<section class="roof-expert"><div class="expert-item '.$styled_class.' '.$class.' first">'. $blog_content_title . $content . $read_more_txt .'</div></section>';

    return $output;
  }
}
add_shortcode( 'roof_blog_content', 'roof_blog_content_function' );
