<?php
/**
 * Blog Content - Shortcode Options
 */
add_action( 'init', 'roof_blog_content_vc_map' );
if ( ! function_exists( 'roof_blog_content_vc_map' ) ) {
  function roof_blog_content_vc_map() {
    vc_map( array(
      "name" => __( "Blog Content", 'roof-core'),
      "base" => "roof_blog_content",
      "description" => __( "Blog Content Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        RoofLib::vt_open_link_tab(),

        array(
          "type"      => 'textfield',
          "heading"   => __('Blog Content Title', 'roof-core'),
          "param_name" => "blog_content_title",
          "value"      => "",
          'admin_label' => true,
          "description" => __( "Enter your Blog Content title and link.", 'roof-core')
        ),
        array(
          "type"      => 'textarea_html',
          "heading"   => __('Content', 'roof-core'),
          "param_name" => "content",
          "value"      => "",
          "description" => __( "Enter your blog content content here.", 'roof-core'),
        ),

        // Read More
        array(
          "type"      => 'textfield',
          "heading"   => __('Read More Text', 'roof-core'),
          "param_name" => "blog_content_read_more_txt",
          "value"      => "",
          "description" => __( "Enter your Blog Content read more text.", 'roof-core')
        ),
        array(
          "type"      => 'href',
          "heading"   => __('Link', 'roof-core'),
          "param_name" => "read_more_link",
          "value"      => "",
          "description" => __( "Set your link for read more.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        RoofLib::vt_class_option(),

        // Style
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Blog Content Title Color', 'roof-core'),
          "param_name" => "title_color",
          "value"      => "",
          "description" => __( "Pick your heading color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        array(
          "type"      => 'textfield',
          "heading"   => __('Title Size', 'roof-core'),
          "param_name" => "title_size",
          "value"      => "",
          "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Read More Color', 'roof-core'),
          "param_name" => "read_more_color",
          "value"      => "",
          "description" => __( "Pick your read more color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        array(
          "type"      => 'colorpicker',
          "heading"   => __('Read More Hover Color', 'roof-core'),
          "param_name" => "read_more_hover_color",
          "value"      => "",
          "description" => __( "Pick your read more hover color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
      )
    )
    );
  }
}
