<?php
/* ==========================================================
  Benefits
=========================================================== */
if ( !function_exists('roof_benefits_function')) {
  function roof_benefits_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'benefits_icon_image'  => '',
      'benefits_icon_width' => '',
      'benefits_title'  => '',
      'title_color'  => '',
      'title_hover_color'  => '',
      'benefit_border'  => '',
      'title_size'  => '',
      'title_weight' => '',
      'open_link'  => '',
      'class'  => '',

    ), $atts));

    // fix unclosed/unwanted paragraph tags in $content
    $content = wpb_js_remove_wpautop($content, true);

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $title_color || $title_size) {
      $inline_style .= '.benefit-item-'.$e_uniqid.' .benefit-title a, .benefit-item-'.$e_uniqid.' .benefit-title {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    if ($title_weight) {
      $inline_style .= '.benefit-item-'.$e_uniqid.' .benefit-title a, .benefit-item-'.$e_uniqid.' .benefit-title {';
      $inline_style .= ( $title_weight ) ? 'font-weight:'. $title_weight .';' : '';
      $inline_style .= '}';
    }
    if ( $title_hover_color) {
      $inline_style .= '.benefit-item-'.$e_uniqid.' .benefit-title a:hover {';
      $inline_style .= ( $title_hover_color ) ? 'color:'. $title_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $benefits_icon_width) {
      $inline_style .= '.benefit-item-'.$e_uniqid.' .roof-icon img {';
      $inline_style .= ( $benefits_icon_width ) ? 'width:'. roof_check_px($benefits_icon_width) .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' benefit-item-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';

    // Service Title
    if ( function_exists( 'vc_parse_multi_attribute' ) ) {
      $parse_args = vc_parse_multi_attribute( $benefits_title );
      $url        = ( isset( $parse_args['url'] ) ) ? $parse_args['url'] : '';
      $title      = ( isset( $parse_args['title'] ) ) ? $parse_args['title'] : '';
      $target     = ( isset( $parse_args['target'] ) ) ? trim( $parse_args['target'] ) : '_self';
    }

    // Service Icon
    $image_url = wp_get_attachment_url( $benefits_icon_image );
    $benefits_icon_image_main = $benefits_icon_image ? '<img src="'.$image_url.'" alt="'. $title .'">' : '';

    if ($url) {
      $benefits_title = '<h4 class="benefit-title"><a href="'. $url .'" target="'. $target .'">'. $title .'</a></h4>';
    } elseif ($title) {
      $benefits_title = '<h4 class="benefit-title">'. $title .'</h4>';
    } else {
      $benefits_title = '';
    }
    if($benefit_border){
      $border_class = 'benefit-border';
    } else {
      $border_class = '';
    }

    $output = '';
    $output .= '<div class="benefit-item '.$border_class.' '.$styled_class.' '. $class .'"><div class="roof-icon">'.$benefits_icon_image_main.'</div><div class="benefit-info">'. $benefits_title . $content .'</div></div>';

    return $output;
  }
}
add_shortcode( 'roof_benefits', 'roof_benefits_function' );
