<?php
/**
 * Benefits - Shortcode Options
 */
add_action( 'init', 'roof_benefits_vc_map' );
if ( ! function_exists( 'roof_benefits_vc_map' ) ) {
  function roof_benefits_vc_map() {
    vc_map( array(
      "name" => __( "Benefits", 'roof-core'),
      "base" => "roof_benefits",
      "description" => __( "Benefits Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Icon', 'roof-core'),
          "param_name" => "benefits_icon_image",
          "value"      => "",
          'admin_label' => true,
          "description" => __( "Set your Benefits icon image.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        RoofLib::vt_notice_field(__( "Content Area", 'roof-core' ),'cntara_opt','cs-warning', ''), // Notice
        array(
          "type"      => 'vc_link',
          "heading"   => __('Benefits Title', 'roof-core'),
          "param_name" => "benefits_title",
          "value"      => "",
          "description" => __( "Enter your Benefits title and link.", 'roof-core'),
        ),
        array(
          "type"      => 'textarea_html',
          "heading"   => __('Content', 'roof-core'),
          "param_name" => "content",
          "value"      => "",
          "description" => __( "Enter your Benefits content here.", 'roof-core'),
        ),

        RoofLib::vt_class_option(),

        // Style
        RoofLib::vt_notice_field(__( "Title Options", 'roof-core' ),'title_opt','cs-warning', ''), // Notice
        array(
          "type"      => 'textfield',
          "heading"   => __('Benefits Icon Width', 'roof-core'),
          "param_name" => "benefits_icon_width",
          "value"      => "",
          "description" => __( "Enter the numeric value for icon width in px.", 'roof-core'),
          "group"       => __('Style', 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Border Bottom', 'roof-core'),
          "param_name"  => "benefit_border",
          "value"       => "",
          "std"         => true,
          "group"       => __('Style', 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Color', 'roof-core'),
          "param_name" => "title_color",
          "value"      => "",
          "group"       => __('Style', 'roof-core'),
          "description" => __( "Pick your heading color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Hover Color', 'roof-core'),
          "param_name" => "title_hover_color",
          "value"      => "",
          "group"       => __('Style', 'roof-core'),
          "description" => __( "Pick your heading hover color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title Size', 'roof-core'),
          "param_name" => "title_size",
          "value"      => "",
          "group"       => __('Style', 'roof-core'),
          "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title Font Weight', 'roof-core'),
          "param_name" => "title_weight",
          "value"      => "",
          "group"       => __('Style', 'roof-core'),
          "description" => __( "Enter the numeric value for title font weight (Ex: 700).", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
      )
    ) );
  }
}
