<?php
/* ==========================================================
  Accordion
=========================================================== */
if( ! function_exists( 'roof_vt_accordion_function' ) ) {
  function roof_vt_accordion_function( $atts, $content = '', $key = '' ) {

    global $vt_accordion_tabs;
    $vt_accordion_tabs = array();

    extract( shortcode_atts( array(
      'id'            => '',
      'class'         => '',
      'one_active'    => '',
      'icon_color'    => '',
      'border_color'  => '',
      'active_tab'    => '',
    ), $atts ) );

    do_shortcode( $content );

    // is not empty clients
    if( empty( $vt_accordion_tabs ) ) { return; }

    $id          = ( $id ) ? ' id="'. $id .'"' : '';
    $class       = ( $class ) ? ' '. $class : '';
    $one_active  = ( $one_active ) ? ' collapse-others' : '';
    $uniqtab     = uniqid();

    $el_style    = ( $border_color ) ? ' style="border-color:'. $border_color .';"' : '';
    $icon_style  = ( $icon_color ) ? ' style="color:'. $icon_color .';"' : '';

    // begin output
    $output      = '<div'. $id .' class="roof-questions '. $one_active . $class .'">';

    foreach ( $vt_accordion_tabs as $key => $tab ) {

      $selected  = ( ( $key + 1 ) == $active_tab ) ? ' show' : '';
      $opened    = ( ( $key + 1 ) == $active_tab ) ? ' show' : '';
      $sub_title = '';
      $icon = '';
      $collapsed = '';

        $title     = '<h4 class="panel-title accordion-title"><button class="btn btn-link panel-title accordion-toggle '.$collapsed.'" data-toggle="collapse" data-target="#blsptAcc-'. esc_attr($key.$uniqtab) .'" aria-expanded="true" aria-controls="blsptAcc-'. esc_attr($key.$uniqtab) .'">'. $icon .'<strong>'. $tab['atts']['title'] .'</strong>'. $sub_title .'</button></h4>';



      $output   .= '<div class="accordion" id="accordion-'.sanitize_title($tab['atts']['title']) .$key .'" role="tablist" aria-multiselectable="true"><div class="card panel panel-default"'. $el_style .'>';
      $output   .= '<div class="panel-heading'. $selected .'">'. $title .'</div>';
      $output   .= '<div id="blsptAcc-'. esc_attr($key.$uniqtab) .'" class="panel-collapse collapse'. $opened .'"><div class="card-body panel-body panel-content">'. do_shortcode( $tab['content'] ) . '</div></div>';
      $output   .= '</div></div>';

    }

    $output     .= '</div>';
    // end output

    return $output;
  }
  add_shortcode( 'vc_accordion', 'roof_vt_accordion_function' );
}

/**
 *
 * Accordion Shortcode
 * @since 1.0.0
 * @version 1.1.0
 *
 */
if( ! function_exists( 'roof_vt_accordion_tab' ) ) {
  function roof_vt_accordion_tab( $atts, $content = '', $key = '' ) {
    global $vt_accordion_tabs;
    $vt_accordion_tabs[]  = array( 'atts' => $atts, 'content' => $content );
    return;
  }
  add_shortcode( 'vc_accordion_tab', 'roof_vt_accordion_tab' );
}
