<?php
/* ==========================================================
  Services
=========================================================== */
if ( !function_exists('roof_about_banner_function')) {
  function roof_about_banner_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'about_banner_style'          => '',
      'about_banner_align'          => '',
      'about_banner_txt_align'      => '',
      'about_banner_image'          => '',
      'about_banner_title_caption'  => '',
      'about_banner_name'           => '',
      'about_banner_profession'     => '',
      'about_banner_title'          => '',
      'about_banner_btn_txt'        => '',
      'about_banner_btn_link'       => '',
      'class'                       => '',

      // Style
      'about_banner_title_color'    => '',
      'about_banner_title_size'     => '',
      'about_banner_content_color'  => '',
      'about_banner_content_size'   => '',
      'title_caption_color'         => '',
      'title_caption_size'          => '',
      'button_color'                => '',
      'button_hover_color'          => '',
      'about_name_color'            => '',
      'about_profession_color'      => '',
      'about_name_hover_color'      => '',

    ), $atts));

    // fix unclosed/unwanted paragraph tags in $content
    $content = wpb_js_remove_wpautop($content, true);

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $about_banner_title_color || $about_banner_title_size) {
      $inline_style .= '.about-'.$e_uniqid.' .about-info h3 {';
      $inline_style .= ( $about_banner_title_color ) ? 'color:'. $about_banner_title_color .';' : '';
      $inline_style .= ( $about_banner_title_size ) ? 'font-size:'. roof_check_px($about_banner_title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $about_banner_content_color || $about_banner_content_size) {
      $inline_style .= '.about-'.$e_uniqid.' .about-info p {';
      $inline_style .= ( $about_banner_content_color ) ? 'color:'. $about_banner_content_color .';' : '';
      $inline_style .= ( $about_banner_content_size ) ? 'font-size:'. roof_check_px($about_banner_content_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $title_caption_color || $title_caption_size) {
      $inline_style .= '.about-'.$e_uniqid.' .about-info h5 {';
      $inline_style .= ( $title_caption_color ) ? 'color:'. $title_caption_color .';' : '';
      $inline_style .= ( $title_caption_size ) ? 'font-size:'. roof_check_px($title_caption_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $button_color ) {
      $inline_style .= '.about-'.$e_uniqid.' .roof-btn {';
      $inline_style .= ( $button_color ) ? 'background-color:'. $button_color .';' : '';
      $inline_style .= '}';
    }
    if ( $button_hover_color ) {
      $inline_style .= '.about-'.$e_uniqid.' .roof-btn:hover {';
      $inline_style .= ( $button_hover_color ) ? 'background-color:'. $button_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $about_name_color ) {
      $inline_style .= '.about-'.$e_uniqid.' .about-info a {';
      $inline_style .= ( $about_name_color ) ? 'color:'. $about_name_color .';' : '';
      $inline_style .= '}';
    }
    if ( $about_name_hover_color ) {
      $inline_style .= '.about-'.$e_uniqid.' .about-info a:hover {';
      $inline_style .= ( $about_name_hover_color ) ? 'color:'. $about_name_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $about_profession_color ) {
      $inline_style .= '.about-detail.about-style-two.about-'.$e_uniqid.' .about-info h5 span {';
      $inline_style .= ( $about_profession_color ) ? 'color:'. $about_profession_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' about-'. $e_uniqid;

		// Image
    $about_banner_image = $about_banner_image ? '<div class="roof-picture"><img src="'.esc_url(wp_get_attachment_url($about_banner_image)).'" alt="Author"></div>' : '';

    // Title Section
    $about_banner_title_caption = $about_banner_title_caption ? '<h5>'.$about_banner_title_caption.'</h5>' : '';
    $about_banner_title = $about_banner_title ? '<h3>'.$about_banner_title.'</h3>' : '';

    // Name & Profession
    if ( function_exists( 'vc_parse_multi_attribute' ) ) {
      $parse_args = vc_parse_multi_attribute( $about_banner_name );
      $url        = ( isset( $parse_args['url'] ) ) ? $parse_args['url'] : '';
      $title      = ( isset( $parse_args['title'] ) ) ? $parse_args['title'] : '';
      $target     = ( isset( $parse_args['target'] ) ) ? trim( $parse_args['target'] ) : '_self';
    }

    if ($url) {
      $about_banner_name = '<h5><a href="'. $url .'" target="'. $target .'">'. $title .'</a></h5>';
    } elseif ($title) {
      $about_banner_name = '<h5>'. $title .'</h5>';
    } else {
      $about_banner_name = '';
    }

    // Profession
     $about_banner_profession = $about_banner_profession ? '<h5><span>'.$about_banner_profession.'</span></h5>':'';

    // Button
    $about_banner_btn_txt = $about_banner_btn_txt ? '<a href="'.$about_banner_btn_link.'" class="roof-btn">'.$about_banner_btn_txt.'</a>' : '';
     if($about_banner_txt_align === 'txt_right_align'){
      $txt_align_class = 'abt-txt-right';
     } else{
      $txt_align_class = '';
     }

    $output = '';

    if($about_banner_style === 'roof-about-two') {
      if($about_banner_align === 'right_align'){
         $output .= '<div class="about-detail about-style-two'.$styled_class.' '.$class.'"><div class="about-wrap">'.$about_banner_image.'<div class="about-info '.$txt_align_class.'">'. $about_banner_title . $about_banner_name . $about_banner_profession .'</div></div></div>';
      } else {
        $output .= '<div class="about-detail about-style-two'.$styled_class.' '.$class.'"><div class="about-wrap"><div class="about-info '.$txt_align_class.'">'. $about_banner_title . $about_banner_name . $about_banner_profession .'</div>'.$about_banner_image.'</div></div>';
      }
    } else {
      if($about_banner_align === 'right_align'){
        $output .= '<div class="about-wrap about-one'.$styled_class.' '.$class.'">'.$about_banner_image.'<div class="about-info '.$txt_align_class.'">'. $about_banner_title_caption . $about_banner_title . $content .$about_banner_btn_txt.'</div></div>';
      } else {
        $output .= '<div class="about-wrap about-one'.$styled_class.' '.$class.'"><div class="about-info '.$txt_align_class.'">'. $about_banner_title_caption . $about_banner_title . $content .$about_banner_btn_txt.'</div>'.$about_banner_image.'</div>';
      }
    }

    return $output;
  }
}
add_shortcode( 'roof_about_banner', 'roof_about_banner_function' );
