<?php
/**
 * About Banner - Shortcode Options
 */
add_action( 'init', 'roof_about_banner_vc_map' );
if ( ! function_exists( 'roof_about_banner_vc_map' ) ) {
  function roof_about_banner_vc_map() {
    vc_map( array(
      "name" => __( "About Banner", 'roof-core'),
      "base" => "roof_about_banner",
      "description" => __( "About Banner Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'About Banner Style', 'roof-core' ),
          'value' => array(
            __( 'Style One', 'roof-core' ) => 'roof-about-one',
            __( 'Style Two', 'roof-core' ) => 'roof-about-two',
          ),
          'admin_label' => true,
          'param_name' => 'about_banner_style',
          'description' => __( 'Select your about banner style.', 'roof-core' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'About Banner Image Position', 'roof-core' ),
          'value' => array(
            __( 'Right', 'roof-core' ) => 'left_align',
            __( 'Left', 'roof-core' ) => 'right_align',
          ),
          'param_name' => 'about_banner_align',
          'description' => __( 'Select your about banner image position.', 'roof-core' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'About Banner Text Align', 'roof-core' ),
          'value' => array(
            __( 'Left', 'roof-core' ) => 'txt_left_align',
            __( 'Right', 'roof-core' ) => 'txt_right_align',
          ),
          'param_name' => 'about_banner_txt_align',
          'description' => __( 'Select your about banner text alignment.', 'roof-core' ),
        ),
        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload About Banner Image', 'roof-core'),
          "param_name" => "about_banner_image",
          "value"      => "",
          "description" => __( "Set your About Banner image.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title Caption', 'roof-core'),
          "param_name" => "about_banner_title_caption",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "description" => __( "Enter your Title Caption here.", 'roof-core')
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title', 'roof-core'),
          "param_name" => "about_banner_title",
          "value"      => "",
          "description" => __( "Enter your Title here.", 'roof-core')
        ),
        array(
          "type"      => 'vc_link',
          "heading"   => __('Name & Link', 'roof-core'),
          "param_name" => "about_banner_name",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-two',
          ),
          "description" => __( "Enter your name and link here.", 'roof-core')
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Profession', 'roof-core'),
          "param_name" => "about_banner_profession",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-two',
          ),
          "description" => __( "Enter your Profession here.", 'roof-core')
        ),
        array(
          "type"      => 'textarea_html',
          "heading"   => __('Content', 'roof-core'),
          "param_name" => "content",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "description" => __( "Enter your About Banner content here.", 'roof-core')
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('About Banner Button Text', 'roof-core'),
          "param_name" => "about_banner_btn_txt",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "description" => __( "Enter your About Banner Button Text here.", 'roof-core')
        ),
        array(
          "type"      => 'href',
          "heading"   => __('About Banner Button Link', 'roof-core'),
          "param_name" => "about_banner_btn_link",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "description" => __( "Enter your About Banner Button link.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Color', 'roof-core'),
          "param_name" => "about_banner_title_color",
          "value"      => "",
          "group"      => "Style",
          "description" => __( "Pick your About Banner Title color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title Size', 'roof-core'),
          "param_name" => "about_banner_title_size",
          "value"      => "",
          "group"      => "Style",
          "description" => __( "Pick your About Banner Title size.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Content Color', 'roof-core'),
          "param_name" => "about_banner_content_color",
          "value"      => "",
          "group"      => "Style",
          "description" => __( "Pick your About Banner Content color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Content Size', 'roof-core'),
          "param_name" => "about_banner_content_size",
          "value"      => "",
          "group"      => "Style",
          "description" => __( "Pick your About Banner Content size.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Caption Color', 'roof-core'),
          "param_name" => "title_caption_color",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "group"      => "Style",
          "description" => __( "Pick your about banner title caption color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Caption Size', 'roof-core'),
          "param_name" => "title_caption_size",
          "value"      => "",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "group"      => "Style",
          "description" => __( "Pick your about banner title caption size.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Button Color', 'roof-core'),
          "param_name" => "button_color",
          "value"      => "",
          "group"      => "Style",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "description" => __( "Pick your about banner button color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Button Hover Color', 'roof-core'),
          "param_name" => "button_hover_color",
          "value"      => "",
          "group"      => "Style",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-one',
          ),
          "description" => __( "Pick your about banner button color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('About Name Color', 'roof-core'),
          "param_name" => "about_name_color",
          "value"      => "",
          "group"      => "Style",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-two',
          ),
          "description" => __( "Pick your about name color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('About Name Hover Color', 'roof-core'),
          "param_name" => "about_name_hover_color",
          "value"      => "",
          "group"      => "Style",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-two',
          ),
          "description" => __( "Pick your about name hover color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('About Profession Color', 'roof-core'),
          "param_name" => "about_profession_color",
          "value"      => "",
          "group"      => "Style",
          'dependency' => array(
            'element' => 'about_banner_style',
            'value' => 'roof-about-two',
          ),
          "description" => __( "Pick your about profession color.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        RoofLib::vt_class_option(),
      )
    ) );
  }
}
