<?php
/*
Plugin Name: Roof Core
Plugin URI: https://victorthemes.com/wp-themes/roof
Description: Plugin to contain shortcodes and custom post types of the Roof theme.
Author: VictorThemes
Author URI: https://victorthemes.com/
Version: 1.7.5
Text Domain: roof-core
*/

if( ! function_exists( 'roof_block_direct_access' ) ) {
	function roof_block_direct_access() {
		if( ! defined( 'ABSPATH' ) ) {
			exit( 'Forbidden' );
		}
	}
}

// Plugin URL
define( 'ROOF_PLUGIN_URL', plugins_url( '/', __FILE__ ) );

// Plugin PATH
define( 'ROOF_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'ROOF_PLUGIN_ASTS', ROOF_PLUGIN_URL . 'assets' );
define( 'ROOF_PLUGIN_IMGS', ROOF_PLUGIN_ASTS . '/images' );
define( 'ROOF_PLUGIN_INC', ROOF_PLUGIN_PATH . 'inc' );

// DIRECTORY SEPARATOR
define ( 'DS' , DIRECTORY_SEPARATOR );

// Roof Shortcode Path
define( 'ROOF_SHORTCODE_BASE_PATH', ROOF_PLUGIN_PATH . 'visual-composer/' );
define( 'ROOF_SHORTCODE_PATH', ROOF_SHORTCODE_BASE_PATH . 'shortcodes/' );

/**
 * Check if Codestar Framework is Active or Not!
 */
function roof_framework_active() {
  return ( defined( 'CS_VERSION' ) ) ? true : false;
}

/* VTHEME_NAME_P */
define('VTHEME_NAME_P', 'Roof');

// Initial File
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if (is_plugin_active('roof-core/roof-core.php')) {

	// Custom Post Type
	require_once( ROOF_PLUGIN_INC . '/custom-post-type.php' );

  // Shortcodes
  require_once( ROOF_SHORTCODE_BASE_PATH . '/vc-setup.php' );
  if (is_plugin_active('js_composer/js_composer.php')) {
    require_once( ROOF_SHORTCODE_BASE_PATH . '/lib/lib.php' );
  }
  require_once( ROOF_PLUGIN_INC . '/custom-shortcodes/theme-shortcodes.php' );
  require_once( ROOF_PLUGIN_INC . '/custom-shortcodes/custom-shortcodes.php' );

  // Widgets
  require_once( ROOF_PLUGIN_INC . '/widgets/get-quote-widget.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/nav-widget.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/recent-posts.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/recent-posts-footer.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/latest-projects.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/testimonial-widget.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/text-widget.php' );
  require_once( ROOF_PLUGIN_INC . '/widgets/widget-extra-fields.php' );

}

/**
 * Plugin language
 */
function roof_plugin_language_setup() {
  load_plugin_textdomain( 'roof-core', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'roof_plugin_language_setup' );

/* WPAUTOP for shortcode output */
if( ! function_exists( 'roof_set_wpautop' ) ) {
  function roof_set_wpautop( $content, $force = true ) {
    if ( $force ) {
      $content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );
    }
    return do_shortcode( shortcode_unautop( $content ) );
  }
}

/* Use shortcodes in text widgets */
add_filter('widget_text', 'do_shortcode');

/* Shortcodes enable in the_excerpt */
add_filter('the_excerpt', 'do_shortcode');

/* Remove p tag and add by our self in the_excerpt */
remove_filter('the_excerpt', 'wpautop');

/* Add Extra Social Fields in Admin User Profile */
function roof_add_twitter_facebook( $contactmethods ) {
  $contactmethods['facebook']   = 'Facebook';
  $contactmethods['twitter']    = 'Twitter';
  $contactmethods['linkedin']   = 'Linkedin';
  return $contactmethods;
}
add_filter('user_contactmethods','roof_add_twitter_facebook',10,1);

/**
 *
 * Encode string for backup options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'cs_encode_string' ) ) {
  function cs_encode_string( $string ) {
    return rtrim( strtr( call_user_func( 'base'. '64' .'_encode', addslashes( gzcompress( serialize( $string ), 9 ) ) ), '+/', '-_' ), '=' );
  }
}

/**
 *
 * Decode string for backup options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'cs_decode_string' ) ) {
  function cs_decode_string( $string ) {
    return unserialize( gzuncompress( stripslashes( call_user_func( 'base'. '64' .'_decode', rtrim( strtr( $string, '-_', '+/' ), '=' ) ) ) ) );
  }
}

/**
 * One Click Install
 * @return Import Demos - Needed Import Demo's
 */
function roof_import_files() {
  return array(
    array(
      'import_file_name'           => 'Roof',
      'import_file_url'            => trailingslashit( ROOF_PLUGIN_URL ) . 'inc/import/content.xml',
      'import_widget_file_url'     => trailingslashit( ROOF_PLUGIN_URL ) . 'inc/import/widget.wie',
      'local_import_csf'           => array(
        array(
          'file_path'   => trailingslashit( ROOF_PLUGIN_URL ) . 'inc/import/theme-options.json',
          'option_name' => '_cs_options',
        ),
      ),
      // 'import_preview_image_url'   => ROOF_PLUGIN_URL . 'inc/import/screenshot-1.png',
      'import_notice'              => __( 'Import process may take 4-6 minutes, please be patient. It\'s really based on your network speed.', 'roof-core' ),
      'preview_url'                => 'http://victorthemes.com/themes/roof',
    ),
  );
}
add_filter( 'pt-ocdi/import_files', 'roof_import_files' );

/**
 * One Click Import Function for CodeStar Framework
 */
if ( ! function_exists( 'csf_after_content_import_execution' ) ) {
  function csf_after_content_import_execution( $selected_import_files, $import_files, $selected_index ) {

    $downloader = new OCDI\Downloader();

    if( ! empty( $import_files[$selected_index]['import_csf'] ) ) {

      foreach( $import_files[$selected_index]['import_csf'] as $index => $import ) {
        $file_path = $downloader->download_file( $import['file_url'], 'demo-csf-import-file-'. $index . '-'. date( 'Y-m-d__H-i-s' ) .'.json' );
        $file_raw  = OCDI\Helpers::data_from_file( $file_path );
        update_option( $import['option_name'], json_decode( $file_raw, true ) );
      }

    } else if( ! empty( $import_files[$selected_index]['local_import_csf'] ) ) {

      foreach( $import_files[$selected_index]['local_import_csf'] as $index => $import ) {
        $file_path = $import['file_path'];
        $file_raw  = OCDI\Helpers::data_from_file( $file_path );
        update_option( $import['option_name'], json_decode( $file_raw, true ) );
      }

    }

    // Put info to log file.
    $ocdi       = OCDI\OneClickDemoImport::get_instance();
    $log_path   = $ocdi->get_log_file_path();

    OCDI\Helpers::append_to_file( 'Codestar Framework files loaded.'. $logs, $log_path );

  }
  add_action('pt-ocdi/after_content_import_execution', 'csf_after_content_import_execution', 3, 99 );
}

/**
 * [roof_after_import_setup]
 * @return Front Page, Post Page & Menu Set
 */
function roof_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
        'primary' => $main_menu->term_id,
      )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home Page' );
    $blog_page_id = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'roof_after_import_setup' );

// Install Demos Menu - Menu Edited
function roof_core_one_click_page( $default_settings ) {
  $default_settings['parent_slug'] = 'themes.php';
  $default_settings['page_title']  = esc_html__( 'Install Demos', 'roof-core' );
  $default_settings['menu_title']  = esc_html__( 'Install Demos', 'roof-core' );
  $default_settings['capability']  = 'import';
  $default_settings['menu_slug']   = 'install_demos';

  return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'roof_core_one_click_page' );

// Model Popup - Width Increased
function roof_ocdi_confirmation_dialog_options ( $options ) {
  return array_merge( $options, array(
    'width'       => 600,
    'dialogClass' => 'wp-dialog',
    'resizable'   => false,
    'height'      => 'auto',
    'modal'       => true,
  ) );
}
add_filter( 'pt-ocdi/confirmation_dialog_options', 'roof_ocdi_confirmation_dialog_options', 10, 1 );

// Disable the branding notice - ProteusThemes
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

function ocdi_plugin_intro_text( $default_text ) {
  $auto_install = admin_url('themes.php?page=install_demos');
  $manual_install = admin_url('themes.php?page=install_demos&import-mode=manual');
  $default_text .= '<h1>Install Demos</h1>
  <div class="vtheme-core_intro-text vtdemo-one-click">
  <div id="poststuff">

    <div class="postbox important-notes">
      <h3><span>Important notes:</span></h3>
      <div class="inside">
        <ol>
          <li>Please note, this import process will take time. So, please be patient.</li>
          <li>Please make sure you\'ve installed recommended plugins before you import this content.</li>
          <li>All images are demo purposes only. So, images may repeat in your site content.</li>
        </ol>
      </div>
    </div>

    <div class="postbox vt-support-box vt-error-box">
      <h3><span>Don\'t Edit Parent Theme Files:</span></h3>
      <div class="inside">
        <p>Don\'t edit any files from parent theme! Use only a <strong>Child Theme</strong> files for your customizations!</p>
        <p>If you get future updates from our theme, you\'ll lose edited customization from your parent theme.</p>
      </div>
    </div>

    <div class="postbox vt-support-box">
      <h3><span>Need Support?</span> <a href="https://www.youtube.com/watch?v=2EYMAuWCn14" target="_blank" class="cs-section-video"><i class="fa fa-youtube-play"></i> <span>How to?</span></a></h3>
      <div class="inside">
        <p>Have any doubts regarding this installation or any other issues? Please feel free to open a ticket in our support center.</p>
        <a href="http://victorthemes.com/docs/roof" class="button-primary" target="_blank">Documentaion</a>
        <a href="https://victorthemes.com/wp-themes/roof/" class="button-primary" target="_blank">Item Page</a>
      </div>
    </div>
    <div class="nav-tab-wrapper vt-nav-tab">
      <a href="'. $auto_install .'" class="nav-tab vt-mode-switch vt-auto-mode nav-tab-active">Auto Import</a>
      <a href="'. $manual_install .'" class="nav-tab vt-mode-switch vt-manual-mode">Manual Import</a>
    </div>

    </div>
  </div>';

  return $default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'ocdi_plugin_intro_text' );
