<?php
/*
 * Recent Posts Widget
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

class roof_recent_post extends WP_Widget {

  /**
   * Specifies the widget name, description, class name and instatiates it
   */
  public function __construct() {
    parent::__construct(
      'roof-recent-post',
      VTHEME_NAME_P . esc_html__( ': Recent Posts With Image', 'roof-core' ),
      array(
        'classname'   => 'recent-post',
        'description' => VTHEME_NAME_P . esc_html__( ' widget that displays recent posts with image.', 'roof-core' )
      )
    );
  }

  /**
   * Generates the back-end layout for the widget
   */
  public function form( $instance ) {
    // Default Values
    $instance   = wp_parse_args( $instance, array(
      'title'    => esc_html__( 'Recent Posts', 'roof-core' ),
      'ptypes'   => 'post',
      'limit'    => '3',
      'date'     => true,
      'category' => '',
      'order' => '',
      'orderby' => '',
    ));

    // Title
    $title_value = esc_attr( $instance['title'] );
    $title_field = array(
      'id'    => $this->get_field_name('title'),
      'name'  => $this->get_field_name('title'),
      'type'  => 'text',
      'title' => esc_html__( 'Title :', 'roof-core' ),
      'wrap_class' => 'roof-cs-widget-fields',
    );
    echo cs_add_element( $title_field, $title_value );

    // Post Type
    $ptypes_value = esc_attr( $instance['ptypes'] );
    $ptypes_field = array(
      'id'    => $this->get_field_name('ptypes'),
      'name'  => $this->get_field_name('ptypes'),
      'type' => 'select',
      'options' => 'post_types',
      'default_option' => esc_html__( 'Select Post Type', 'roof-core' ),
      'title' => esc_html__( 'Post Type :', 'roof-core' ),
    );
    echo cs_add_element( $ptypes_field, $ptypes_value );

    // Limit
    $limit_value = esc_attr( $instance['limit'] );
    $limit_field = array(
      'id'    => $this->get_field_name('limit'),
      'name'  => $this->get_field_name('limit'),
      'type'  => 'text',
      'title' => esc_html__( 'Limit :', 'roof-core' ),
      'help' => esc_html__( 'How many posts want to show?', 'roof-core' ),
    );
    echo cs_add_element( $limit_field, $limit_value );

    // Date
    $date_value = esc_attr( $instance['date'] );
    $date_field = array(
      'id'    => $this->get_field_name('date'),
      'name'  => $this->get_field_name('date'),
      'type'  => 'switcher',
      'on_text'  => esc_html__( 'Yes', 'roof-core' ),
      'off_text'  => esc_html__( 'No', 'roof-core' ),
      'title' => esc_html__( 'Display Date :', 'roof-core' ),
    );
    echo cs_add_element( $date_field, $date_value );

    // Category
    $category_value = esc_attr( $instance['category'] );
    $category_field = array(
      'id'    => $this->get_field_name('category'),
      'name'  => $this->get_field_name('category'),
      'type'  => 'text',
      'title' => esc_html__( 'Category :', 'roof-core' ),
      'help' => esc_html__( 'Enter category slugs with comma(,) for multiple items', 'roof-core' ),
    );
    echo cs_add_element( $category_field, $category_value );

    // Order
    $order_value = esc_attr( $instance['order'] );
    $order_field = array(
      'id'    => $this->get_field_name('order'),
      'name'  => $this->get_field_name('order'),
      'type' => 'select',
      'options'   => array(
        'ASC' => 'Ascending',
        'DESC' => 'Descending',
      ),
      'default_option' => esc_html__( 'Select Order', 'roof-core' ),
      'title' => esc_html__( 'Order :', 'roof-core' ),
    );
    echo cs_add_element( $order_field, $order_value );

    // Orderby
    $orderby_value = esc_attr( $instance['orderby'] );
    $orderby_field = array(
      'id'    => $this->get_field_name('orderby'),
      'name'  => $this->get_field_name('orderby'),
      'type' => 'select',
      'options'   => array(
        'none' => esc_html__('None', 'roof-core'),
        'ID' => esc_html__('ID', 'roof-core'),
        'author' => esc_html__('Author', 'roof-core'),
        'title' => esc_html__('Title', 'roof-core'),
        'name' => esc_html__('Name', 'roof-core'),
        'type' => esc_html__('Type', 'roof-core'),
        'date' => esc_html__('Date', 'roof-core'),
        'modified' => esc_html__('Modified', 'roof-core'),
        'rand' => esc_html__('Random', 'roof-core'),
      ),
      'default_option' => esc_html__( 'Select OrderBy', 'roof-core' ),
      'title' => esc_html__( 'OrderBy :', 'roof-core' ),
    );
    echo cs_add_element( $orderby_field, $orderby_value );

  }

  /**
   * Processes the widget's values
   */
  public function update( $new_instance, $old_instance ) {
    $instance = $old_instance;

    // Update values
    $instance['title']        = strip_tags( stripslashes( $new_instance['title'] ) );
    $instance['ptypes']       = strip_tags( stripslashes( $new_instance['ptypes'] ) );
    $instance['limit']        = strip_tags( stripslashes( $new_instance['limit'] ) );
    $instance['date']         = strip_tags( stripslashes( $new_instance['date'] ) );
    $instance['category']     = strip_tags( stripslashes( $new_instance['category'] ) );
    $instance['order']        = strip_tags( stripslashes( $new_instance['order'] ) );
    $instance['orderby']      = strip_tags( stripslashes( $new_instance['orderby'] ) );

    return $instance;
  }

  /**
   * Output the contents of the widget
   */
  public function widget( $args, $instance ) {
    // Extract the arguments
    extract( $args );

    $title          = apply_filters( 'widget_title', $instance['title'] );
    $ptypes         = $instance['ptypes'];
    $limit          = $instance['limit'];
    $display_date   = $instance['date'];
    $category       = $instance['category'];
    $order          = $instance['order'];
    $orderby        = $instance['orderby'];

    $args = array(
      // other query params here,
      'post_type' => esc_attr($ptypes),
      'posts_per_page' => (int)$limit,
      'orderby' => esc_attr($orderby),
      'order' => esc_attr($order),
      'category_name' => esc_attr($category),
      'ignore_sticky_posts' => 1,
     );

     $roof_rpw = new WP_Query( $args );
     global $post;

    // Display the markup before the widget
    echo $before_widget;

    if ( $title ) {
      echo $before_title . $title . $after_title;
    }

    if ($roof_rpw->have_posts()) : while ($roof_rpw->have_posts()) : $roof_rpw->the_post();
  ?>
<div class="recent-post">
    <div class="roof-picture">
    <?php
      $roof_post_imgg = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fullsize', false, '' );
      $roof_post_imgg = isset($roof_post_imgg[0]) ? $roof_post_imgg[0] : '';
      $resizer = cs_get_option('disable_resizer');

      if($resizer) {
        $roof_post_img = $roof_post_imgg;
      } else {
        $roof_post_img = aq_resize( $roof_post_imgg, '70', '70', true );
      }
      if($roof_post_img){
        $roof_post_img_actual = '<img src="'.esc_url($roof_post_img).'" alt="'.get_the_title().'">';
      } else {
        $roof_post_img_actual = '';
      }
    ?>

      <a href="<?php the_permalink(); ?>"><?php echo $roof_post_img_actual; ?></a>
    </div>
    <div class="post-info">
      <h5 class="post-title"><a href="<?php esc_url(the_permalink()) ?>"><?php the_title(); ?></a></h5>
      <?php if ($display_date === '1') { ?>
      <div class="post-time">
      <?php
        echo get_the_date('d'); esc_html_e( 'th ', 'roof-core' );
        echo get_the_date('M'). ' ' .get_the_date('Y');
      ?>
      </div>
    </div>
    <?php } ?>
</div>

  <?php
    endwhile; endif;
    wp_reset_postdata();
    // Display the markup after the widget
    echo $after_widget;
  }
}

// Register the widget using an annonymous function
function roof_recent_post_function() {
  register_widget( "roof_recent_post" );
}
add_action( 'widgets_init', 'roof_recent_post_function' );
