<?php
/*
 * All Custom Shortcode for [theme_name] theme.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

if( ! function_exists( 'roof_vt_shortcodes' ) ) {
  function roof_vt_shortcodes( $options ) {

    $options       = array();

    /* Download Brochure Shortcodes */
    $options[]     = array(
      'title'      => __('Widget Shortcodes', 'roof'),
      'shortcodes' => array(

        array(
          'name'          => 'vt_download_brochure',
          'title'         => __('Download Brochure Shortcodes', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'download_txt',
              'type'      => 'text',
              'title'     => __('Download Brochure Text', 'roof'),
            ),
            array(
              'id'        => 'download_icon',
              'type'      => 'icon',
              'title'     => __('Download Brochure Text', 'roof'),
            ),
            array(
              'id'        => 'download_link',
              'type'      => 'text',
              'title'     => __('Download Brochure Link', 'roof'),
            ),
            array(
              'id'        => 'vt_target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),
            array(
              'id'        => 'icon_size',
              'type'      => 'text',
              'title'     => __('Download Brochure icon size', 'roof'),
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => __('Download Brochure text size', 'roof'),
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure bg color', 'roof'),
            ),
            array(
              'id'        => 'bg_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure bg hover color', 'roof'),
            ),
            array(
              'id'        => 'icon_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure icon color', 'roof'),
            ),
            array(
              'id'        => 'icon_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure icon hover color', 'roof'),
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure border color', 'roof'),
            ),
            array(
              'id'        => 'txt_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure text color', 'roof'),
            ),
            array(
              'id'        => 'txt_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Download Brochure text color', 'roof'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),
          ),
        ),
      ),
    );

    /* Topbar Shortcodes */
    $options[]     = array(
      'title'      => __('Topbar Shortcodes', 'roof'),
      'shortcodes' => array(

        // WPML
        array(
          'name'          => 'vt_topbar_wpml',
          'title'         => __('WPML Language Dropdown', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

          ),

        ),
        // WPML

        // Topbar Links
        array(
          'name'          => 'top_bar_links',
          'title'         => __('Top-bar Links', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_top_link',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'link_title',
              'type'      => 'text',
              'title'     => __('Title', 'roof')
            ),
            array(
              'id'        => 'title_link',
              'type'      => 'text',
              'title'     => __('Link', 'roof')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),

          ),

        ),
        // Topbar Links

        // Topbar Country Menu
        array(
          'name'          => 'top_bar_ctry_menus',
          'title'         => __('Top-bar Country Menu', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'roof_top_ctry_menu',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),
            array(
              'id'        => 'main_menu',
              'type'      => 'text',
              'title'     => __('Main Menu Text', 'roof'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'sub_menu_text',
              'type'      => 'text',
              'title'     => __('Sub-menu Text', 'roof')
            ),
            array(
              'id'        => 'sub_menu_link',
              'type'      => 'text',
              'title'     => __('Sub-menu Link', 'roof')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),

          ),

        ),
        // Topbar Country Menu

      ),
    );

    /* Header Shortcodes */
    $options[]     = array(
      'title'      => __('Header Shortcodes', 'roof'),
      'shortcodes' => array(

        // Address Info
        array(
          'name'          => 'vt_address_infos',
          'title'         => __('Address Info', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_address_info',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'address_style',
              'type'      => 'select',
              'options'   => array(
                'style-one' => __('Style One', 'roof'),
                'style-two' => __('Style Two', 'roof'),
              ),
              'title'     => __('Address Style', 'roof'),
            ),
            array(
              'id'        => 'info_icon',
              'type'      => 'icon',
              'title'     => __('Info Icon', 'roof')
            ),
            array(
              'id'        => 'info_icon_color',
              'type'      => 'color_picker',
              'title'     => __('Info Icon Color', 'roof'),
            ),
            array(
              'id'        => 'info_main_text',
              'type'      => 'text',
              'title'     => __('Main Text', 'roof')
            ),
            array(
              'id'        => 'info_main_text_link',
              'type'      => 'text',
              'title'     => __('Main Text Link', 'roof')
            ),
            array(
              'id'        => 'info_main_text_color',
              'type'      => 'color_picker',
              'title'     => __('Main Text Color', 'roof'),
            ),
            array(
              'id'        => 'info_sec_text',
              'type'      => 'text',
              'title'     => __('Secondary Text', 'roof'),
              'dependency'  => array('address_style', '==', 'style-one'),
            ),
            array(
              'id'        => 'info_sec_text_link',
              'type'      => 'text',
              'title'     => __('Secondary Text Link', 'roof'),
              'dependency'  => array('address_style', '==', 'style-one'),
            ),
            array(
              'id'        => 'info_sec_text_color',
              'type'      => 'color_picker',
              'title'     => __('Secondary Text Color', 'roof'),
              'dependency'  => array('address_style', '==', 'style-one'),
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),

          ),

        ),
        // Address Info

      ),
    );

    /* Content Shortcodes */
    $options[]     = array(
      'title'      => __('Content Shortcodes', 'roof'),
      'shortcodes' => array(

        // Spacer
        array(
          'name'          => 'vc_empty_space',
          'title'         => __('Spacer', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'height',
              'type'      => 'text',
              'title'     => __('Height', 'roof'),
              'attributes' => array(
                'placeholder'     => '20px',
              ),
            ),

          ),
        ),
        // Spacer

        // Content Heading
        array(
          'name'          => 'vt_content_heading',
          'title'         => __('Content Heading', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'ctn_heading',
              'type'      => 'text',
              'title'     => __('Heading Text', 'roof'),
            ),
            array(
              'id'        => 'ctn_heading_tag',
              'type'      => 'text',
              'title'     => __('Heading Tag', 'roof'),
              'attributes' => array(
                'placeholder'     => 'Eg: h3',
              ),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),
          ),
        ),
        // Content Heading

        // Social Icons
        array(
          'name'          => 'vt_socials',
          'title'         => __('Social Icons', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_social',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'social_select',
              'type'      => 'select',
              'options'   => array(
                'style-one' => __('Style One (Menubar)', 'roof'),
                'style-two' => __('Style Two (Footer)', 'roof'),
                'style-three' => __('Style Three', 'roof'),
              ),
              'title'     => __('Social Icons Style', 'roof'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),
            array(
              'id'        => 'social_title',
              'type'      => 'text',
              'title'     => __('Social Icons Title', 'roof'),
              'dependency'  => array('social_select', '==', 'style-two'),
            ),

            // Colors
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Colors', 'roof')
            ),
            array(
              'id'        => 'icon_color',
              'type'      => 'color_picker',
              'title'     => __('Icon Color', 'roof'),
              'wrap_class' => 'column_third',
            ),
            array(
              'id'        => 'icon_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Icon Hover Color', 'roof'),
              'wrap_class' => 'column_third',
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => __('Backrgound Color', 'roof'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '!=', 'style-two'),
            ),
            array(
              'id'        => 'bg_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Backrgound Hover Color', 'roof'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '!=', 'style-two'),
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => __('Border Color', 'kroth'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '==', 'style-three'),
            ),
            array(
              'id'        => 'border_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Border Hover Color', 'kroth'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '==', 'style-three'),
            ),

            // Icon Size
            array(
              'id'        => 'icon_size',
              'type'      => 'text',
              'title'     => __('Icon Size', 'roof'),
              'wrap_class' => 'column_full',
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => __('Link', 'roof')
            ),
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => __('Social Icon', 'roof')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),

          ),

        ),
        // Social Icons

        // Table
        array(
          'name'          => 'table',
          'title'         => __('Table', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'class',
              'type'      => 'text',
              'title'     => __('Class', 'roof'),
            ),
            array(
              'id'        => 'content',
              'type'      => 'textarea',
              'title'     => __('Table Content', 'roof'),
              'wrap_class' => 'column_full',
              'shortcode' => true,
              'default'   => '[thead][tr][th]Title One[/th][th]Title Two[/th][th]Title Three[/th][th]Title Four[/th][/tr][/thead][tbody][tr][td]<a href="http://asdsd">Item One</a>[/td][td]Item One[/td][td]<strong>Item One</strong>[/td][td]Item One[/td][/tr][tr][td]Item Two[/td][td]Item Two[/td][td]Item Two[/td][td]Item Two[/td][/tr][/tbody]'
            ),

          ),

        ),
        // Table

        // Useful Links
        array(
          'name'          => 'vt_useful_links',
          'title'         => __('Useful Links', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_useful_link',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'column_width',
              'type'      => 'select',
              'title'     => __('Column Width', 'roof'),
              'options'        => array(
                'full-width' => __('One Column', 'roof'),
                'half-width' => __('Two Column', 'roof'),
                'third-width' => __('Three Column', 'roof'),
              ),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'title_link',
              'type'      => 'text',
              'title'     => __('Link', 'roof')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),
            array(
              'id'        => 'link_title',
              'type'      => 'text',
              'title'     => __('Title', 'roof')
            ),

          ),

        ),
        // Useful Links

        // Education List
        array(
          'name'          => 'vt_education_lists',
          'title'         => __('Education List', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_education_list',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

            // Colors
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Colors', 'roof')
            ),
            array(
              'id'        => 'title_color',
              'type'      => 'color_picker',
              'title'     => __('Title Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            array(
              'id'        => 'text_color',
              'type'      => 'color_picker',
              'title'     => __('Text Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            array(
              'id'        => 'bullet_color',
              'type'      => 'color_picker',
              'title'     => __('Bullet Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),

            // Size
            array(
              'id'        => 'title_size',
              'type'      => 'text',
              'title'     => __('Title Size', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
              'attributes' => array(
                'placeholder'     => 'Eg: 14px',
              ),
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => __('Text Size', 'roof'),
              'attributes' => array(
                'placeholder'     => 'Eg: 14px',
              ),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'bullet_top_space',
              'type'      => 'text',
              'title'     => __('Bullet Top Space', 'roof'),
              'attributes' => array(
                'placeholder'     => 'Eg: 12px',
              ),
              'wrap_class' => 'column_full',
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => __('Title', 'roof')
            ),
            array(
              'id'        => 'text',
              'type'      => 'text',
              'title'     => __('Text', 'roof')
            ),
            array(
              'id'        => 'text_link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => __('Text Link', 'roof')
            ),

          ),

        ),
        // Education List

        // Simple Image List
        array(
          'name'          => 'vt_image_lists',
          'title'         => __('Simple Image List', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_image_list',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'get_image',
              'type'      => 'upload',
              'title'     => __('Image', 'roof')
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => __('Link', 'roof')
            ),
            array(
              'id'    => 'open_tab',
              'type'  => 'switcher',
              'std'   => false,
              'title' => __('Open link to new tab?', 'roof')
            ),

          ),

        ),
        // Simple Image List

        // Download Button
        array(
          'name'          => 'vt_download_btn',
          'title'         => __('Download Button', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'link_icon',
              'type'      => 'icon',
              'title'     => __('Icon', 'roof'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => __('Link Text', 'roof'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => __('Link', 'roof'),
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

            // Normal Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Normal Mode', 'roof')
            ),
            array(
              'id'        => 'text_color',
              'type'      => 'color_picker',
              'title'     => __('Text Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            array(
              'id'        => 'icon_color',
              'type'      => 'color_picker',
              'title'     => __('Icon Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => __('Background Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            // Hover Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Hover Mode', 'roof')
            ),
            array(
              'id'        => 'text_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Text Hover Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            array(
              'id'        => 'icon_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Icon Hover Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),
            array(
              'id'        => 'bg_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Background Hover Color', 'roof'),
              'wrap_class' => 'column_third el-hav-border',
            ),

            // Size
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Font Sizes', 'roof')
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => __('Text Size', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
              'attributes' => array(
                'placeholder'     => 'Eg: 14px',
              ),
            ),
            array(
              'id'        => 'icon_size',
              'type'      => 'text',
              'title'     => __('Icon Size', 'roof'),
              'attributes' => array(
                'placeholder'     => 'Eg: 18px',
              ),
              'wrap_class' => 'column_half el-hav-border',
            ),

          ),
        ),
        // Download Button

        // Simple Link
        array(
          'name'          => 'vt_simple_link',
          'title'         => __('Simple Link', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'link_style',
              'type'      => 'select',
              'title'     => __('Link Style', 'roof'),
              'options'        => array(
                'link-underline' => __('Link Underline', 'roof'),
                'link-arrow-right' => __('Link Arrow (Right)', 'roof'),
                'link-arrow-left' => __('Link Arrow (Left)', 'roof'),
              ),
            ),
            array(
              'id'        => 'link_icon',
              'type'      => 'icon',
              'title'     => __('Icon', 'roof'),
              'value'      => '',
              'dependency'  => array('link_style', '!=', 'link-underline'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => __('Link Text', 'roof'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => __('Link', 'roof'),
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

            // Normal Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Normal Mode', 'roof')
            ),
            array(
              'id'        => 'text_color',
              'type'      => 'color_picker',
              'title'     => __('Text Color', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => __('Border Color', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
              'dependency'  => array('link_style', '==', 'link-underline'),
            ),
            // Hover Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Hover Mode', 'roof')
            ),
            array(
              'id'        => 'text_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Text Hover Color', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'border_hover_color',
              'type'      => 'color_picker',
              'title'     => __('Border Hover Color', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
              'dependency'  => array('link_style', '==', 'link-underline'),
            ),

            // Size
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Font Sizes', 'roof')
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => __('Text Size', 'roof'),
              'attributes' => array(
                'placeholder'     => 'Eg: 14px',
              ),
            ),

          ),
        ),
        // Simple Link

        // Blockquotes
        array(
          'name'          => 'vt_blockquote',
          'title'         => __('Blockquote', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => __('Text Size', 'roof'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),
            array(
              'id'        => 'content_color',
              'type'      => 'color_picker',
              'title'     => __('Content Color', 'roof'),
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => __('Background Color', 'roof'),
            ),
            // Content
            array(
              'id'        => 'content',
              'type'      => 'textarea',
              'title'     => __('Content', 'roof'),
            ),

          ),

        ),
        // Blockquotes

        // List Styles
        array(
          'name'          => 'vt_address_lists',
          'title'         => __('Address Lists', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_address_list',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

            // Colors
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => __('Colors', 'roof')
            ),
            array(
              'id'        => 'text_color',
              'type'      => 'color_picker',
              'title'     => __('Text Color', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'title_color',
              'type'      => 'color_picker',
              'title'     => __('Title Color', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
            ),

            // Size
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => __('Text Size', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'title_size',
              'type'      => 'text',
              'title'     => __('Title Size', 'roof'),
              'wrap_class' => 'column_half el-hav-border',
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'list_title',
              'type'      => 'text',
              'title'     => __('Title', 'roof')
            ),
            array(
              'id'        => 'list_text',
              'type'      => 'textarea',
              'title'     => __('Text', 'roof')
            ),

          ),

        ),
        // List Styles

        // WPML
        array(
          'name'          => 'roof_wpml',
          'title'         => esc_html__('WPML', 'roof-core'),
          'fields'        => array(

            array(
            'id'        => 'custom_class',
            'type'      => 'text',
            'title'     => esc_html__('Custom Class', 'roof-core'),
            ),
            array(
              'id'        => 'wpml_lang_style',
              'type'      => 'select',
              'options'      => array(
                'dropdown'   => esc_html__('Dropdown', 'roof-core'),
                'horizontal' => esc_html__('Horizontal', 'roof-core'),
                'vertical'   => esc_html__('Vertical', 'roof-core'),
              ),
              'title'     => esc_html__('WPML Style', 'roof-core'),
            ),
            array(
              'id'        => 'wpml_lang_type',
              'type'      => 'select',
              'options'           => array(
                'native_name'     => esc_html__('Native Name', 'roof-core'),
                'translated_name' => esc_html__('Translated Name', 'roof-core'),
                'language_code'   => esc_html__('Language Code', 'roof-core'),
              ),
              'title'     => esc_html__('Language Type', 'roof-core'),
            ),
            array(
              'id'        => 'wpml_flag',
              'type'      => 'switcher',
              'title'     => esc_html__('Remove Flag', 'roof-core'),
              'info'      => 'Remove Flag from Language'
            ),
          ),
        ),

      ),
    );

    /* Footer Shortcodes */
    $options[]     = array(
      'title'      => __('Footer Shortcodes', 'roof'),
      'shortcodes' => array(

        // Footer Menus
        array(
          'name'          => 'vt_footer_menus',
          'title'         => __('Footer Menu Links', 'roof'),
          'view'          => 'clone',
          'clone_id'      => 'vt_footer_menu',
          'clone_title'   => __('Add New', 'roof'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => __('Custom Class', 'roof'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'menu_title',
              'type'      => 'text',
              'title'     => __('Menu Title', 'roof')
            ),
            array(
              'id'        => 'menu_link',
              'type'      => 'text',
              'title'     => __('Menu Link', 'roof')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => __('Open New Tab?', 'roof'),
              'on_text'     => __('Yes', 'roof'),
              'off_text'     => __('No', 'roof'),
            ),

          ),

        ),
        // Footer Menus

      ),
    );

  return $options;

  }
  add_filter( 'cs_shortcode_options', 'roof_vt_shortcodes' );
}
