<?php
/* Download Brochure */
function vt_download_brochure_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "download_txt" => '',
    "download_link" => '',
    "vt_target_tab" => '',
    "download_icon" => '',
    // Colors
    "bg_color" => '',
    "bg_hover_color" => '',
    "border_color" => '',
    "icon_color" => '',
    "icon_hover_color" => '',
    "txt_color" => '',
    "txt_hover_color" => '',
    // Size
    "icon_size" => '',
    "text_size" => '',

    "custom_class" => '',
  ), $atts));

  // Shortcode Style CSS
  $e_uniqid       = uniqid();
  $inline_style   = '';

  // Colors & Size
  if ( $txt_color || $text_size ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn {';
    $inline_style .= ( $txt_color ) ? 'color:'. $txt_color .';' : '';
    $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size).';' : '';
    $inline_style .= '}';
  }
  if ( $txt_hover_color ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn-gray-border:hover, .roof-btn-gray-border:focus {';
    $inline_style .= ( $txt_hover_color ) ? 'color:'. $txt_hover_color .';' : '';
    $inline_style .= '}';
  }
  if ( $icon_color || $icon_size ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn .fa {';
    $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
    $inline_style .= ( $icon_size ) ? 'font-size:'.roof_core_check_px($icon_size).';' : '';
    $inline_style .= '}';
  }
  if ( $icon_hover_color ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn:hover .fa{';
    $inline_style .= ( $icon_hover_color ) ? 'color:'. $icon_hover_color .';' : '';
    $inline_style .= '}';
  }
  if ( $bg_color ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn-gray-border {';
    $inline_style .= ( $bg_color ) ? 'background-color:'. $bg_color .';' : '';
    $inline_style .= '}';
  }
  if ( $border_color ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn-gray-border {';
    $inline_style .= ( $border_color ) ? 'border-color:'. $border_color .';' : '';
    $inline_style .= '}';
  }
  if ( $bg_hover_color ) {
    $inline_style .= '.download-brochures-'. $e_uniqid .' .roof-btn-gray-border:hover {';
    $inline_style .= ( $bg_hover_color ) ? 'background-color:'. $bg_hover_color .';' : '';
    $inline_style .= '}';
  }

  $vt_target_tab = ( $vt_target_tab === '1' ) ? ' target="_blank"' : '';

$download_icon = $download_icon ? '<i class="'.$download_icon.'" aria-hidden="true"></i>' : '';
if($download_link){
  $down_btn = '<a href="'.$download_link.'" "'.$vt_target_tab.'" class="roof-btn roof-btn-gray-border">'.$download_icon.$download_txt.'</a>';
} else {
  $down_btn = '<span class="roof-btn roof-btn-gray-border">'.$download_icon.$download_txt.'</span>' ;
}

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' download-brochures-'. $e_uniqid;

  $result = '<div class="roof-widget widget-download-brochures '.$styled_class.' '.$custom_class.'" id="roof-widget-placeholder-3">
          '.$down_btn.'
        </div>';
  return $result;

}
add_shortcode("vt_download_brochure", "vt_download_brochure_function");

/* Topbar Links */
function top_bar_links_function($atts, $content = true) {
   extract(shortcode_atts(array(
      "custom_class" => ''
   ), $atts));

   $result = '<ul class="nav navbar-nav '. $custom_class .'">'. do_shortcode($content) .'</ul>';
   return $result;

}
add_shortcode("top_bar_links", "top_bar_links_function");

/* Topbar Link */
function vt_top_link_function($atts, $content = NULL) {
   extract(shortcode_atts(array(
      "target_tab" => '',
      "title_link" => '',
      "link_title" => ''
   ), $atts));

   $title_link = ( isset( $title_link ) ) ? 'href="'. $title_link . '"' : '';
   $target_tab = ( $target_tab === '1' ) ? ' target="_blank"' : '';

   $result = '<li><a '. $title_link . $target_tab .'>'. $link_title .'</a></li>';
   return $result;

}
add_shortcode("vt_top_link", "vt_top_link_function");

/* Topbar Country Menus */
function top_bar_ctry_menus_function($atts, $content = true) {
   extract(shortcode_atts(array(
      "main_menu"     => '',
      "custom_class" => ''
   ), $atts));

   $result = '<ul class="nav navbar-nav '. $custom_class .'"><li class="dropdown country-menu"><a href="#0" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-delay="0" data-close-others="false">'.$main_menu.'<i class="fa fa-angle-down" aria-hidden="true"></i></a><ul class="dropdown-menu">'. do_shortcode($content) .'</ul></li></ul>';
   return $result;

}
add_shortcode("top_bar_ctry_menus", "top_bar_ctry_menus_function");

/* Topbar Country Menu */
function roof_top_ctry_menu_function($atts, $content = NULL) {
   extract(shortcode_atts(array(
      "target_tab" => '',
      "sub_menu_text" => '',
      "sub_menu_link" => ''
   ), $atts));

   $sub_menu_link = ( isset( $sub_menu_link ) ) ? 'href="'. $sub_menu_link . '"' : '';
   $target_tab = ( $target_tab === '1' ) ? ' target="_blank"' : '';

   $result = '<li><a '. $sub_menu_link . $target_tab .'>'. $sub_menu_text .'</a></li>';
   return $result;

}
add_shortcode("roof_top_ctry_menu", "roof_top_ctry_menu_function");

/* Table */
function table_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "class" => '',
  ), $atts));

  $result = '<div class="roof-open-positions"><div class="roof-table"><table class="'. $class .'">'. do_shortcode($content) .'</table></div></div>';
  return $result;
}
add_shortcode("table", "table_function");

/* Thead */
function thead_function($atts, $content = true) {
  extract(shortcode_atts(array(), $atts));

  $result = '<thead>'. do_shortcode($content) .'</thead>';
  return $result;
}
add_shortcode("thead", "thead_function");

/* TR */
function tr_function($atts, $content = true) {
  extract(shortcode_atts(array(), $atts));

  $result = '<tr>'. do_shortcode($content) .'</tr>';
  return $result;
}
add_shortcode("tr", "tr_function");

/* TH */
function th_function($atts, $content = true) {
  extract(shortcode_atts(array(), $atts));

  $result = '<th>'. do_shortcode($content) .'</th>';
  return $result;
}
add_shortcode("th", "th_function");

/* Tbody */
function tbody_function($atts, $content = true) {
  extract(shortcode_atts(array(), $atts));

  $result = '<tbody>'. do_shortcode($content) .'</tbody>';
  return $result;
}
add_shortcode("tbody", "tbody_function");

/* TD */
function td_function($atts, $content = true) {
  extract(shortcode_atts(array(), $atts));

  $result = '<td>'. do_shortcode($content) .'</td>';
  return $result;
}
add_shortcode("td", "td_function");

/* Spacer */
function vt_spacer_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "height" => '',
  ), $atts));

  $result = do_shortcode('[vc_empty_space height="'. $height .'"]');
  return $result;

}
add_shortcode("vt_spacer", "vt_spacer_function");

/* Content Heading */
function vt_content_heading_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "ctn_heading" => '',
    "ctn_heading_tag" => '',
    "custom_class" => '',
  ), $atts));

  $ctn_heading_tag = $ctn_heading_tag ? $ctn_heading_tag : 'h3';

  $result = '<'.$ctn_heading_tag.' class="detail-title">'.$ctn_heading.'</'.$ctn_heading_tag.'>';
  return $result;
}
add_shortcode("vt_content_heading", "vt_content_heading_function");

/* Social Icons */
function vt_socials_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "social_select" => '',
    "social_title" => '',
    "custom_class" => '',
    // Colors
    "icon_color" => '',
    "icon_hover_color" => '',
    "bg_color" => '',
    "bg_hover_color" => '',
    "border_color"  => '',
    "border_hover_color" => '',
    "icon_size" => '',
  ), $atts));

  // Atts
  if($social_select === 'style-two') {
    $social_style = 'style-two ';
  } elseif($social_select === 'style-three') {
    $social_style = 'style-three ';
  } else {
    $social_style = 'style-one ';
  }

  // Shortcode Style CSS
  $e_uniqid       = uniqid();
  $inline_style   = '';

  // Colors & Size
  if ( $icon_color || $icon_size ) {
    $inline_style .= '.roof-socials-'. $e_uniqid .'.style-two i, .roof-socials-'. $e_uniqid .'.style-one i, .roof-socials-'. $e_uniqid .'.style-three i {';
    $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
    $inline_style .= ( $icon_size ) ? 'font-size:'. roof_core_check_px($icon_size) .';' : '';
    $inline_style .= '}';
  }

    if ( $icon_hover_color ) {
      $inline_style .= '.roof-socials-'. $e_uniqid .'.style-one a:hover i, .roof-socials-'. $e_uniqid .'.style-one span:hover i, .roof-socials-'. $e_uniqid .'.style-two a:hover i, .roof-socials-'. $e_uniqid .'.style-two span:hover i, .roof-socials-'. $e_uniqid .'.style-three a:hover i, .roof-socials-'. $e_uniqid .'.style-three span:hover i {';
      $inline_style .= ( $icon_hover_color ) ? 'color:'. $icon_hover_color .';' : '';
      $inline_style .= '}';
    }

  if($social_select != 'style-two') {
    if ( $bg_color ) {
      $inline_style .= '.roof-socials-'. $e_uniqid .'.style-one a, .roof-socials-'. $e_uniqid .'.style-one span, .roof-socials-'. $e_uniqid .'.style-three a, .roof-socials-'. $e_uniqid .'.style-three span {';
      $inline_style .= ( $bg_color ) ? 'background-color:'. $bg_color .';' : '';
      $inline_style .= '}';
    }
  }

  if($social_select != 'style-two') {
    if ( $bg_hover_color ) {
      $inline_style .= '.roof-socials-'. $e_uniqid .'.style-one a:hover, .roof-socials-'. $e_uniqid .'.style-one span:hover, .roof-socials-'. $e_uniqid .'.style-three a:hover, .roof-socials-'. $e_uniqid .'.style-three span:hover {';
      $inline_style .= ( $bg_hover_color ) ? 'background-color:'. $bg_hover_color .';' : '';
      $inline_style .= '}';
    }
  }
  if($social_select === 'style-three') {
    if ( $border_color ) {
      $inline_style .= '.roof-socials-'. $e_uniqid .'.style-three a, .roof-socials-'. $e_uniqid .'.style-three span {';
      $inline_style .= ( $border_color ) ? 'border-color:'. $border_color .';' : '';
      $inline_style .= '}';
    }
    if ( $border_hover_color ) {
      $inline_style .= '.roof-socials-'. $e_uniqid .'.style-three a:hover, .roof-socials-'. $e_uniqid .'.style-three span:hover {';
      $inline_style .= ( $border_hover_color ) ? 'border-color:'. $border_hover_color .';' : '';
      $inline_style .= '}';
    }
  }

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' roof-socials-'. $e_uniqid;

  if($social_select === 'style-two') {
    $social_title = $social_title ? '<h6>'.$social_title.'</h6>' : '';
  } else {
    $social_title = '';
  }

  $result = '<div class=" roof-social '. $social_style . $custom_class . $styled_class .'">'.$social_title.''. do_shortcode($content) .'</div>';
  return $result;

}
add_shortcode("vt_socials", "vt_socials_function");

/* Social Icon */
function vt_social_function($atts, $content = NULL) {
   extract(shortcode_atts(array(
      "social_link" => '',
      "social_icon" => '',
      "target_tab" => ''
   ), $atts));

   // $social_link = ( isset( $social_link ) ) ? 'href="'. $social_link . '"' : '';
   $target_tab = ( $target_tab === '1' ) ? ' target="_blank"' : '';
   $social_link_main = $social_link ? '<a href="'. $social_link .'" '. $target_tab .' class="'. str_replace('fa ', 'icon-', $social_icon) .'"><i class="'. $social_icon .'"></i></a>' : '<span class="'. str_replace('fa ', 'icon-', $social_icon) .'"><i class="'. $social_icon .'"></i></span>';

   $result = $social_link_main;
   return $result;

}
add_shortcode("vt_social", "vt_social_function");

/* Educational Lists */
function vt_education_lists_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "custom_class" => '',
    // Colors
    "title_color" => '',
    "text_color" => '',
    "bullet_color" => '',
    // Size
    "title_size" => '',
    "text_size" => '',
    "bullet_top_space" => '',
  ), $atts));

  // Shortcode Style CSS
  $e_uniqid       = uniqid();
  $inline_style   = '';

  // Colors & Size
  if ( $title_color || $title_size ) {
    $inline_style .= '.roof-education-'. $e_uniqid .'.roof-education li strong {';
    $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
    $inline_style .= ( $title_size ) ? 'font-size:'. $title_size .';' : '';
    $inline_style .= '}';
  }
  if ( $text_color || $text_size ) {
    $inline_style .= '.roof-education-'. $e_uniqid .'.roof-education li, .roof-education-'. $e_uniqid .'.roof-education li a {';
    $inline_style .= ( $text_color ) ? 'color:'. $text_color .';' : '';
    $inline_style .= ( $text_size ) ? 'font-size:'. $text_size .';' : '';
    $inline_style .= '}';
  }
  if ( $bullet_color || $bullet_top_space ) {
    $inline_style .= '.roof-education-'. $e_uniqid .'.roof-education li:before {';
    $inline_style .= ( $bullet_color ) ? 'background-color:'. $bullet_color .';' : '';
    $inline_style .= ( $bullet_top_space ) ? 'top:'. $bullet_top_space .';' : '';
    $inline_style .= '}';
  }

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' roof-education-'. $e_uniqid;

  $result = '<ul class="roof-education '. $custom_class . $styled_class .'">'. do_shortcode($content) .'</ul>';
  return $result;

}
add_shortcode("vt_education_lists", "vt_education_lists_function");

/* Educational List */
function vt_education_list_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "title" => '',
    "text" => '',
    "text_link" => ''
  ), $atts));

  // Atts
  $title = ($title) ? '<strong>'. $title .'</strong>' : '';
  if ($text_link) {
    $text_link_open = '<a href="'. $text_link .'" target="_blank">';
    $text_link_close = '</a>';
  } else {
    $text_link_open = '';
    $text_link_close = '';
  }

  $result = '<li>'. $title . $text_link_open . $text . $text_link_close .'</li>';
  return $result;

}
add_shortcode("vt_education_list", "vt_education_list_function");

/* Simple Images */
function vt_image_lists_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "custom_class" => '',
  ), $atts));
  $content = wpb_js_remove_wpautop($content, true);
  $result = '<ul class="simple-fix '. $custom_class .'">'. do_shortcode($content) .'</ul>';
  return $result;

}
add_shortcode("vt_image_lists", "vt_image_lists_function");

/* Simple Image */
function vt_image_list_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "get_image" => '',
    "link" => '',
    "open_tab" => ''
  ), $atts));

  // Atts
  if ($get_image) {
    $my_image = ($get_image) ? '<img src="'. $get_image .'" alt="">' : '';
  } else {
    $my_image = '';
  }
  if ($link) {
    $open_tab = $open_tab ? ' target="_blank"' : '';
    $link_o = '<a href="'. $link .'" '. $open_tab .'>';
    $link_c = '</a>';
  } else {
    $link_o = '';
    $link_c = '';
  }

  $result = '<li>'. $link_o . $my_image . $link_c .'</li>';
  return $result;

}
add_shortcode("vt_image_list", "vt_image_list_function");

/* Download Button */
function vt_download_btn_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "link_icon" => '',
    "link_text" => '',
    "link" => '',
    "target_tab" => '',
    "custom_class" => '',
    // Normal
    "text_color" => '',
    "icon_color" => '',
    "bg_color" => '',
    // Hover
    "text_hover_color" => '',
    "icon_hover_color" => '',
    "bg_hover_color" => '',
    // Size
    "text_size" => '',
    "icon_size" => '',
  ), $atts));

  // Atts
  $link_icon = $link_icon ? '<i class="'. $link_icon .'"></i>' : '';
  $target_tab = $target_tab ? ' target="_blank"' : '';

  // Shortcode Style CSS
  $e_uniqid       = uniqid();
  $inline_style   = '';

  // Colors & Size
  if ( $text_color || $text_size || $bg_color ) {
    $inline_style .= '.roof-dwnd-btn-'. $e_uniqid .'.roof-download-btn {';
    $inline_style .= ( $text_color ) ? 'color:'. $text_color .';' : '';
    $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size) .';' : '';
    $inline_style .= ( $bg_color ) ? 'background-color:'. $bg_color .';' : '';
    $inline_style .= '}';
  }
  if ( $text_hover_color || $bg_hover_color ) {
    $inline_style .= '.roof-dwnd-btn-'. $e_uniqid .'.roof-download-btn:hover {';
    $inline_style .= ( $text_hover_color ) ? 'color:'. $text_hover_color .';' : '';
    $inline_style .= ( $bg_hover_color ) ? 'background-color:'. $bg_hover_color .';' : '';
    $inline_style .= '}';
  }
  if ( $icon_color || $icon_size ) {
    $inline_style .= '.roof-dwnd-btn-'. $e_uniqid .'.roof-download-btn i {';
    $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
    $inline_style .= ( $icon_size ) ? 'font-size:'. roof_core_check_px($icon_size) .';' : '';
    $inline_style .= '}';
  }
  if ( $icon_hover_color ) {
    $inline_style .= '.roof-dwnd-btn-'. $e_uniqid .'.roof-download-btn:hover i {';
    $inline_style .= ( $icon_hover_color ) ? 'color:'. $icon_hover_color .';' : '';
    $inline_style .= '}';
  }

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' roof-dwnd-btn-'. $e_uniqid;

  $result = '<a href="'. $link .'" '. $target_tab .' class="roof-download-btn '. $custom_class . $styled_class .'">'. $link_icon . $link_text .'</a>';
  return $result;

}
add_shortcode("vt_download_btn", "vt_download_btn_function");

/* Simple Underline Link */
function vt_simple_link_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "link_style" => '',
    "link_icon" => '',
    "link_text" => '',
    "link" => '',
    "target_tab" => '',
    "custom_class" => '',
    // Normal
    "text_color" => '',
    "border_color" => '',
    // Hover
    "text_hover_color" => '',
    "border_hover_color" => '',
    // Size
    "text_size" => '',
  ), $atts));

  // Atts
  $target_tab = $target_tab ? ' target="_blank"' : '';
  if ($link_style === 'link-arrow-right') {
    $arrow_icon = $link_icon ? ' <i class="'. $link_icon .'"></i>' : '';
  } elseif ($link_style === 'link-arrow-left') {
    $arrow_icon = $link_icon ? ' <i class="'. $link_icon .'"></i>' : '';
  } else {
    $arrow_icon = '';
  }
  $link_style = $link_style ? $link_style.'' : 'link-underline';

  // Shortcode Style CSS
  $e_uniqid       = uniqid();
  $inline_style   = '';

  // Colors & Size
  if ( $text_color || $text_size ) {
    $inline_style .= '.roof-simple-link-'. $e_uniqid .'.roof-'. $link_style .', .roof-simple-link-'. $e_uniqid .'.roof-link-arrow-left i, .roof-simple-link-'. $e_uniqid .'.roof-link-arrow-right i {';
    $inline_style .= ( $text_color ) ? 'color:'. $text_color .';' : '';
    $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size) .';' : '';
    $inline_style .= '}';
  }
  if ( $text_hover_color ) {
    $inline_style .= 'a.roof-simple-link-'. $e_uniqid .'.roof-'.$link_style.'.simple-link:hover, .roof-simple-link-'. $e_uniqid .'.roof-link-arrow-right:hover, .roof-simple-link-'. $e_uniqid .'.roof-link-arrow-left:hover, .roof-simple-link-'. $e_uniqid .'.roof-link-arrow-right:hover i, .roof-simple-link-'. $e_uniqid .'.roof-link-arrow-left:hover i {';
    $inline_style .= ( $text_hover_color ) ? 'color:'. $text_hover_color .';' : '';
    $inline_style .= '}';
  }
  if ( $border_color ) {
    $inline_style .= '.roof-simple-link-'. $e_uniqid .'.roof-'. $link_style .' {';
    $inline_style .= ( $border_color ) ? 'border-color:'. $border_color .';' : '';
    $inline_style .= '}';
  }
  if ( $border_hover_color ) {
    $inline_style .= '.roof-simple-link-'. $e_uniqid .'.roof-'. $link_style .':hover {';
    $inline_style .= ( $border_hover_color ) ? 'border-color:'. $border_hover_color .';' : '';
    $inline_style .= '}';
  }

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' roof-simple-link-'. $e_uniqid;

  $result = '<a href="'. $link .'" '. $target_tab .' class="simple-link roof-'.$link_style . ' '. $custom_class . $styled_class .'">'. $link_text . $arrow_icon .'</a>';
  return $result;

}
add_shortcode("vt_simple_link", "vt_simple_link_function");

/* Topbar WPML */
function vt_topbar_wpml_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "custom_class" => ''
  ), $atts));

  $output   = '';

  if ( is_wpml_activated() ) {
    global $sitepress;
    $sitepress_settings = $sitepress->get_settings();
    $icl_get_languages  = icl_get_languages();

    if ( ! empty( $icl_get_languages ) ) {

      $output .= '<div class="roof-tr-element '. $custom_class .'"><div class="roof-top-dropdown roof-wpml-dropdown">';

      // current language
      $output .= '<a href="#" class="roof-top-active">';
      foreach ( $icl_get_languages as $id => $current_lang ) {
        if ( $current_lang['active'] ) {
          $output .= $current_lang['translated_name'];
          $output .= '<i class="fa fa-angle-down"></i>';
        }
      }
      $output .= '</a>';

      // list languages
      $output .= '<ul class="roof-topdd-content">';
      foreach ( $icl_get_languages as $id => $language ) {
        if ( ! $language['active'] ) {
          $output .= '<li>';
          $output .= '<a href="'. $language['url'] .'">';
          $output .= $language['translated_name'];
          $output .= '</a>';
          $output .= '</li>';
        }
        // print_r($language);
      }
      $output .= '</ul>';
      $output .= '</div>';
      $output .= '</div>';
    }

  } else {
    $output .= '<p class="wpml-not-active">Please Activate WPML Plugin</p>';
  }

  return $output;

}
add_shortcode("vt_topbar_wpml", "vt_topbar_wpml_function");

/* Address Infos */
function vt_address_infos_function($atts, $content = true) {
   extract(shortcode_atts(array(
      "custom_class" => ''
   ), $atts));

   $result = '<div class="header-right '. $custom_class .'"><div class="contact-details">'. do_shortcode($content) .'</div></div>';
   return $result;

}
add_shortcode("vt_address_infos", "vt_address_infos_function");

/* Address Info */
function vt_address_info_function($atts, $content = NULL) {
   extract(shortcode_atts(array(
      "address_style" => '',
      "info_icon" => '',
      "info_icon_color" => '',
      "info_main_text" => '',
      "info_main_text_link" => '',
      "info_main_text_color" => '',
      "info_sec_text" => '',
      "info_sec_text_link" => '',
      "info_sec_text_color" => '',
      "target_tab" => ''
   ), $atts));

   // Color
   $info_icon_color = $info_icon_color ? 'color:'. $info_icon_color .';' : '';
   $info_main_text_color = $info_main_text_color ? 'color:'. $info_main_text_color .';' : '';
   $info_sec_text_color = $info_sec_text_color ? 'color:'. $info_sec_text_color .';' : '';

   $address_style = ( $address_style === 'style-two' ) ? 'roof-ai-two' : '';
   $target_tab = ( $target_tab === '1' ) ? ' target="_blank"' : '';
   $info_icon = ( isset( $info_icon ) ) ? '<div class="pull-left"><i class="'. $info_icon .'" style="'. $info_icon_color .'"></i></div>' : '';

   if (isset( $info_main_text ) && !$info_main_text_link ) {
      $info_main_text = '<span style="'. $info_main_text_color .'">'. $info_main_text .'</span>';
   } elseif (isset( $info_main_text ) && isset( $info_main_text_link )) {
      $info_main_text = '<span><a href="'. $info_main_text_link .'" '. $target_tab .'  style="'. $info_main_text_color .'">'. $info_main_text .'</a></span>';
   } else {
      $info_main_text = '';
   }
   if (isset( $info_sec_text ) && !$info_sec_text_link ) {
      $info_sec_text = '<p style="'. $info_sec_text_color .'">'. $info_sec_text .'</p>';
   } elseif (isset( $info_sec_text ) && isset( $info_sec_text_link )) {
      $info_sec_text = '<a href="'. $info_sec_text_link .'" '. $target_tab .' style="'. $info_sec_text_color .'">'. $info_sec_text .'</a>';
   } else {
      $info_sec_text = '';
   }

   $result = '<div class="contact-item '. $address_style .'">'. $info_icon .'<div class="contact-info">'. $info_main_text . $info_sec_text .'</div></div>';
   return $result;

}
add_shortcode("vt_address_info", "vt_address_info_function");

/* Topbar Country Menu */
function vt_useful_links_function($atts, $content = true) {
   extract(shortcode_atts(array(
      "column_width" => '',
      "custom_class" => ''
   ), $atts));

   $result = '<ul class="roof-useful-links '. $custom_class .' '. $column_width .'">'. do_shortcode($content) .'</ul>';
   return $result;

}
add_shortcode("vt_useful_links", "vt_useful_links_function");

/* Useful Link */
function vt_useful_link_function($atts, $content = NULL) {
   extract(shortcode_atts(array(
      "target_tab" => '',
      "title_link" => '',
      "link_title" => ''
   ), $atts));

   $title_link = ( isset( $title_link ) ) ? 'href="'. $title_link . '"' : '';
   $target_tab = ( $target_tab === '1' ) ? ' target="_blank"' : '';

   $result = '<li><a '. $title_link . $target_tab .'>'. $link_title .'</a></li>';
   return $result;

}
add_shortcode("vt_useful_link", "vt_useful_link_function");

/* Footer Menus */
function vt_footer_menus_function($atts, $content = true) {
   extract(shortcode_atts(array(
      "custom_class" => ''
   ), $atts));

   $result = '<ul class="footer-nav-links footer-menu '. $custom_class .'">'. do_shortcode($content) .'</ul>';
   return $result;

}
add_shortcode("vt_footer_menus", "vt_footer_menus_function");

/* Footer Menu */
function vt_footer_menu_function($atts, $content = NULL) {
   extract(shortcode_atts(array(
      "menu_title" => '',
      "menu_link" => '',
      "target_tab" => ''
   ), $atts));

   $menu_link = ( isset( $menu_link ) ) ? 'href="'. $menu_link . '"' : '';
   $target_tab = ( $target_tab === '1' ) ? ' target="_blank"' : '';

   $result = '<li><a '. $menu_link . $target_tab .'>'. $menu_title .'</a></li>';
   return $result;

}
add_shortcode("vt_footer_menu", "vt_footer_menu_function");

/* Blockquote */
function vt_blockquote_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "blockquote_style" => '',
    "text_size" => '',
    "custom_class" => '',
    "content_color" => '',
    "border_color"  => '',
    "bg_color" => ''
  ), $atts));

  $content = wpb_js_remove_wpautop($content, true);
  // Shortcode Style CSS
  $e_uniqid        = uniqid();
  $inline_style  = '';

  // Text Color
  if ( $border_color || $bg_color ) {
    $inline_style .= '.roof-blockquote-'. $e_uniqid .' {';
    $inline_style .= ( $border_color ) ? 'border-color:'. $border_color .';' : '';
    $inline_style .= ( $bg_color ) ? 'background-color:'. $bg_color .';' : '';
    $inline_style .= '}';
  }
  if ( $text_size || $content_color ) {
    $inline_style .= '.roof-blockquote-'.$e_uniqid.' p {';
    $inline_style .= ( $text_size ) ? 'font-size:'. roof_check_px($text_size) .';' : '';
    $inline_style .= ( $content_color ) ? 'color:'. $content_color .';' : '';
    $inline_style .= '}';
  }

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' roof-blockquote-'. $e_uniqid;

  // Style
  $blockquote_style = ($blockquote_style === 'style-two') ? 'blockquote-two ' : '';

  $result = '<blockquote class="'. $blockquote_style . $custom_class . $styled_class .'">'. $content .'</blockquote>';
  return $result;

}
add_shortcode("vt_blockquote", "vt_blockquote_function");

/* List Styles Lists */
function vt_address_lists_function($atts, $content = true) {
  extract(shortcode_atts(array(
    "custom_class" => '',
    // Colors
    "text_color" => '',
    "title_color" => '',
    // Size
    "text_size" => '',
    "title_size" => '',
  ), $atts));

  // Shortcode Style CSS
  $e_uniqid       = uniqid();
  $inline_style   = '';

  if ( $text_color || $text_size ) {
    $inline_style .= '.roof-list-'. $e_uniqid .' li {';
    $inline_style .= ( $text_color ) ? 'color:'. $text_color .';' : '';
    $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size) .';' : '';
    $inline_style .= '}';
  }
  if ( $title_size || $title_color ) {
    $inline_style .= '.roof-list-'. $e_uniqid .'.roof-list-three li strong {';
    $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
    $inline_style .= ( $title_size ) ? 'font-size:'. roof_core_check_px($title_size) .';' : '';
    $inline_style .= '}';
  }

  // add inline style
  add_inline_style( $inline_style );
  $styled_class  = ' roof-list-'. $e_uniqid;

  // Output
  $output = '';

  $output .= '<ul class="roof-list-three '. $custom_class . $styled_class .'">';
  $output .= do_shortcode($content);
  $output .= '</ul>';

  return $output;

}
add_shortcode("vt_address_lists", "vt_address_lists_function");

/* List Styles List */
function vt_address_list_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "list_title" => '',
    "list_text" => '',
  ), $atts));

  // Atts
  $list_title = $list_title ? '<strong>'. $list_title .' :</strong> ' : '';
  $list_text = $list_text ? $list_text : '';

  $result = '<li>'. $list_title . $list_text .'</li>';
  return $result;

}
add_shortcode("vt_address_list", "vt_address_list_function");

/* WPML */
function roof_wpml_function($atts, $content = NULL) {
  extract(shortcode_atts(array(
    "custom_class" => '',
    "wpml_lang_type" => '',
    "wpml_lang_style" => '',
    "wpml_flag" => '',
    "wpml_list" => ''
  ), $atts));

  $output   = '';

  if ( is_wpml_activated() ) {
    global $sitepress;
    $sitepress_settings = $sitepress->get_settings();
    $icl_get_languages  = icl_get_languages();

    if ( ! empty( $icl_get_languages ) ) {
      // Horizontal View
      if($wpml_lang_style === 'horizontal') {
          $languages = icl_get_languages('skip_missing=0&orderby=code');

            if(!empty($languages)){
                echo '<div id="horizontal_language_list"><ul>';
                  foreach($languages as $l){

                    if($wpml_lang_type === 'translated_name') {
                      $lang_type = $l['translated_name'];
                    } elseif($wpml_lang_type === 'language_code') {
                      $lang_type = $l['language_code'];
                    }
                    else {
                      $lang_type = $l['native_name'];
                    }

                      echo '<li>';
                        if($l['country_flag_url']){
                            if(!$l['active']) echo '<a href="'.$l['url'].'">';
                              if (!$wpml_flag)  {
                                echo '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
                              }
                            if(!$l['active']) echo '</a>';
                        }
                      if(!$l['active']) echo '<a href="'.$l['url'].'">';
                        echo icl_disp_language($lang_type);
                      if(!$l['active']) echo '</a>';
                        echo '</li>';
                  }
                echo '</ul></div>';
            }
    } elseif($wpml_lang_style === 'vertical') {
        // Vertical View
        $languages = icl_get_languages('skip_missing=0&orderby=code');
          if(!empty($languages)){
                echo '<div id="vertical_language_list"><ul>';
                  foreach($languages as $l){

                    if($wpml_lang_type === 'translated_name') {
                      $lang_type = $l['translated_name'];
                    } elseif($wpml_lang_type === 'language_code') {
                      $lang_type = $l['language_code'];
                    }
                    else {
                      $lang_type = $l['native_name'];
                    }

                    echo '<li>';
                    if($l['country_flag_url']){
                        if(!$l['active']) echo '<a href="'.$l['url'].'">';
                          if (!$wpml_flag)  {
                            echo '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
                          }
                        if(!$l['active']) echo '</a>';
                    }
                    if(!$l['active']) echo '<a href="'.$l['url'].'">';
                      echo icl_disp_language($lang_type);
                    if(!$l['active']) echo '</a>';
                      echo '</li>';
                  }
                echo '</ul></div>';
          }
    } else {
      // Dropdown View
      $languages = icl_get_languages('skip_missing=0&orderby=code');
        $output .= '';

          // current language
          $output .= '<ul class="nav navbar-nav">';
          $output .= '<li class="dropdown country-menu"><a href="#" class="roof-top-active">';
          foreach ( $languages as $current_lang ) {

                  if($wpml_lang_type === 'translated_name') {
                    $lang_type = $current_lang['translated_name'];
                  } elseif($wpml_lang_type === 'language_code') {
                    $lang_type = $current_lang['language_code'];
                  }
                  else {
                    $lang_type = $current_lang['native_name'];
                  }

                  if ( $current_lang['active'] ) {
                    if (!$wpml_flag)  {
                      $output .= '<img src="'.$current_lang['country_flag_url'].'" height="12" alt="'.$current_lang['language_code'].'" width="18" />';
                    }
                      $output .= $lang_type;
                      $output .= '<i class="fa fa-angle-down"></i>';
                  }
          }
          $output .= '</a>';

          // list languages
          $output .= '<ul class="dropdown-menu">';
          foreach ( $languages as $language ) {
            if ( ! $language['active'] ) {

                  if($wpml_lang_type === 'translated_name') {
                    $lang_type = $language['translated_name'];
                  } elseif($wpml_lang_type === 'language_code') {
                    $lang_type = $language['language_code'];
                  }
                  else {
                    $lang_type = $language['native_name'];
                  }

                $output .= '<li>';
                $output .= '<a href="'. $language['url'] .'">';
              if (!$wpml_flag)  {
                $output .= '<img src="'.$language['country_flag_url'].'" height="12" alt="'.$language['language_code'].'" width="18" />';
              }
                $output .= $lang_type;
                $output .= '</a>';
                $output .= '</li>';
            }
            // print_r($language);
          }
          $output .= '</ul></li>';
          $output .= '</ul>';

    }
  }

  } else {
    $output .= '<p class="wpml-not-active">Please Activate WPML Plugin</p>';
  }

  return $output;

}
add_shortcode("roof_wpml", "roof_wpml_function");

/* Current Year - Shortcode */
if( ! function_exists( 'roof_current_year' ) ) {
  function roof_current_year() {
    return date('Y');
  }
  add_shortcode( 'roof_current_year', 'roof_current_year' );
}

/* Get Home Page URL - Via Shortcode */
if( ! function_exists( 'roof_home_url' ) ) {
  function roof_home_url() {
    return esc_url( home_url( '/' ) );
  }
  add_shortcode( 'roof_home_url', 'roof_home_url' );
}

/* Page Title - Shortcode */
if( ! function_exists( 'roof_page_title' ) ) {
  function roof_page_title() {
    global $post;
    $title = $post->post_title;
    return urlencode($title);
  }
  add_shortcode( 'roof_page_title', 'roof_page_title' );
}

/* Page URL - Shortcode */
if( ! function_exists( 'roof_page_url' ) ) {
  function roof_page_url() {
    global $post;
    $page_url = get_permalink($post->ID );
    return urlencode($page_url);
  }
  add_shortcode( 'roof_page_url', 'roof_page_url' );
}
